"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadConnectors = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("@kbn/triggers-actions-ui-plugin/public/common/constants");
var i18n = _interopRequireWildcard(require("../translations"));
var _kibana = require("../../../lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to load all connectors for a given action type.
 * @param actionTypeId
 * @param toasts
 */
const useLoadConnectors = ({
  actionTypeId,
  toasts
}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)(['load-connectors', actionTypeId], async () => {
    const queryResult = await (0, _constants.loadAllActions)({
      http
    });
    const filteredData = queryResult.filter(connector => !connector.isMissingSecrets && connector.actionTypeId === actionTypeId);
    return filteredData;
  }, {
    retry: false,
    keepPreviousData: true,
    onError: error => {
      if (error.name !== 'AbortError') {
        toasts === null || toasts === void 0 ? void 0 : toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
          title: i18n.LOAD_CONNECTORS_ERROR_MESSAGE
        });
      }
    }
  });
};
exports.useLoadConnectors = useLoadConnectors;