"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostIsolationPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _get_event_details_field_values = require("../../../../lib/endpoint/utils/get_event_details_field_values");
var _use_cases_from_alerts = require("../../../../../detections/containers/detection_engine/alerts/use_cases_from_alerts");
var _isolate = require("./isolate");
var _unisolate = require("./unisolate");
var _use_alert_response_actions_support = require("../../../../hooks/endpoint/use_alert_response_actions_support");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostIsolationPanel = exports.HostIsolationPanel = /*#__PURE__*/_react.default.memo(({
  details,
  cancelCallback,
  successCallback,
  isolateAction
}) => {
  const {
    isSupported: alertHostSupportsResponseActions,
    details: {
      agentId,
      agentType,
      hostName
    }
  } = (0, _use_alert_response_actions_support.useAlertResponseActionsSupport)(details);
  const alertId = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: '_id',
    field: '_id'
  }, details), [details]);
  const {
    casesInfo
  } = (0, _use_cases_from_alerts.useCasesFromAlerts)({
    alertId
  });
  const formProps = (0, _react.useMemo)(() => {
    return {
      endpointId: agentId,
      hostName,
      casesInfo,
      agentType,
      cancelCallback,
      successCallback
    };
  }, [agentId, agentType, cancelCallback, casesInfo, hostName, successCallback]);
  if (!alertHostSupportsResponseActions) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      "data-test-subj": "unsupportedAlertHost"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detections.hostIsolation.alertHostNotSupported",
      defaultMessage: "The alert's host ({hostName}) does not support host isolation response actions.",
      values: {
        hostName
      }
    }));
  }
  return isolateAction === 'isolateHost' ? /*#__PURE__*/_react.default.createElement(_isolate.IsolateHost, formProps) : /*#__PURE__*/_react.default.createElement(_unisolate.UnisolateHost, formProps);
});
HostIsolationPanel.displayName = 'HostIsolationContent';