"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_LEGEND_HEIGHT = exports.DraggableLegend = exports.DEFAULT_WIDTH = void 0;
var _eui = require("@elastic/eui");
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _draggable_legend_item = require("./draggable_legend_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_LEGEND_HEIGHT = exports.MIN_LEGEND_HEIGHT = 175;
const DEFAULT_WIDTH = exports.DEFAULT_WIDTH = 165; // px

const useStyles = (height, minWidth) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    draggableLegendContainer: (0, _react2.css)`
      height: ${height}px;
      overflow: auto;
      scrollbar-width: thin;
      width: 100%;

      @media only screen and (min-width: ${euiTheme.breakpoint.m}) {
        width: 165px;
      }

      min-width: ${minWidth}px;

      &::-webkit-scrollbar {
        height: ${euiTheme.size.base};
        width: ${euiTheme.size.base};
      }

      &::-webkit-scrollbar-thumb {
        background-clip: content-box;
        background-color: ${(0, _polished.rgba)(euiTheme.colors.darkShade, 0.5)};
        border: ${euiTheme.border.radius.small} solid transparent;
      }

      &::-webkit-scrollbar-corner,
      &::-webkit-scrollbar-track {
        background-color: transparent;
      }
    `
  };
};
const DraggableLegendComponent = ({
  className,
  height = 0,
  legendItems,
  minWidth = DEFAULT_WIDTH,
  isInlineActions = false
}) => {
  const styles = useStyles(height === 0 ? MIN_LEGEND_HEIGHT : height, minWidth);
  if (legendItems.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.draggableLegendContainer,
    className: className,
    "data-test-subj": "draggable-legend"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, legendItems.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item.dataProviderId,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggable_legend_item.DraggableLegendItem, {
    legendItem: item,
    isInlineActions: isInlineActions
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    "data-test-subj": "draggable-legend-spacer",
    size: "s"
  }))))));
};
DraggableLegendComponent.displayName = 'DraggableLegendComponent';
const DraggableLegend = exports.DraggableLegend = /*#__PURE__*/_react.default.memo(DraggableLegendComponent);