"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilterLensAction = void 0;
var _actions = require("@kbn/cell-actions/actions");
var _utils = require("@kbn/cell-actions/actions/utils");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _translations = require("@kbn/cell-actions/src/actions/translations");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/lens-plugin/public");
var _is_in_security_app = require("../../../../common/hooks/is_in_security_app");
var _store = require("../../../../timelines/store");
var _utils2 = require("../../utils");
var _types = require("../../../../../common/types");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isDataColumnsValid(data) {
  return !!data && data.length > 0 && data.every(({
    columnMeta
  }) => columnMeta && (0, _utils2.fieldHasCellActions)(columnMeta.field));
}
const createFilterLensAction = ({
  id,
  order,
  store,
  services,
  negate
}) => {
  const {
    application,
    notifications,
    data: dataService,
    topValuesPopover,
    timelineDataService
  } = services;
  const {
    query: {
      filterManager: timelineFilterManager
    }
  } = timelineDataService;
  let currentAppId;
  application.currentAppId$.subscribe(appId => {
    currentAppId = appId;
  });
  const getTimelineById = _store.timelineSelectors.getTimelineByIdSelector();
  return (0, _public.createAction)({
    id,
    order,
    getIconType: () => negate ? 'minusInCircle' : 'plusInCircle',
    getDisplayName: () => negate ? _i18n.i18n.translate('xpack.securitySolution.actions.filterOutTimeline', {
      defaultMessage: `Filter out`
    }) : _i18n.i18n.translate('xpack.securitySolution.actions.filterForTimeline', {
      defaultMessage: `Filter for`
    }),
    type: _constants.DefaultCellActionTypes.FILTER,
    isCompatible: async ({
      embeddable,
      data
    }) => !(0, _presentationPublishing.hasBlockingError)(embeddable) && (0, _public2.isLensApi)(embeddable) && isDataColumnsValid(data) && (0, _is_in_security_app.isInSecurityApp)(currentAppId),
    execute: async ({
      data
    }) => {
      var _data$, _data$$columnMeta, _data$2, _data$2$columnMeta, _data$2$columnMeta$so, _data$3, _data$4, _data$4$columnMeta, _data$4$columnMeta$so;
      const field = (_data$ = data[0]) === null || _data$ === void 0 ? void 0 : (_data$$columnMeta = _data$.columnMeta) === null || _data$$columnMeta === void 0 ? void 0 : _data$$columnMeta.field;
      const isCounter = ((_data$2 = data[0]) === null || _data$2 === void 0 ? void 0 : (_data$2$columnMeta = _data$2.columnMeta) === null || _data$2$columnMeta === void 0 ? void 0 : (_data$2$columnMeta$so = _data$2$columnMeta.sourceParams) === null || _data$2$columnMeta$so === void 0 ? void 0 : _data$2$columnMeta$so.type) === 'value_count';
      const rawValue = (_data$3 = data[0]) === null || _data$3 === void 0 ? void 0 : _data$3.value;
      const mayBeDataViewId = (_data$4 = data[0]) === null || _data$4 === void 0 ? void 0 : (_data$4$columnMeta = _data$4.columnMeta) === null || _data$4$columnMeta === void 0 ? void 0 : (_data$4$columnMeta$so = _data$4$columnMeta.sourceParams) === null || _data$4$columnMeta$so === void 0 ? void 0 : _data$4$columnMeta$so.indexPatternId;
      const dataViewId = typeof mayBeDataViewId === 'string' ? mayBeDataViewId : undefined;
      const value = (0, _utils.filterOutNullableValues)((0, _utils.valueToArray)(rawValue));
      if (!(0, _utils.isValueSupportedByDefaultActions)(value)) {
        notifications.toasts.addWarning({
          title: _translations.ACTION_INCOMPATIBLE_VALUE_WARNING
        });
        return;
      }
      if (!field) return;
      topValuesPopover.closePopover();
      const timeline = getTimelineById(store.getState(), _types.TimelineId.active);
      // timeline is open add the filter to timeline, otherwise add filter to global filters
      const filterManager = timeline !== null && timeline !== void 0 && timeline.show ? timelineFilterManager : dataService.query.filterManager;

      // If value type is value_count, we want to filter an `Exists` filter instead of a `Term` filter
      if (isCounter) {
        (0, _actions.addExistsFilter)({
          filterManager,
          key: field,
          negate: !!negate,
          dataViewId
        });
        return;
      }
      const addFilter = negate === true ? _actions.addFilterOut : _actions.addFilterIn;
      addFilter({
        filterManager,
        fieldName: field,
        value,
        dataViewId
      });
    }
  });
};
exports.createFilterLensAction = createFilterLensAction;