"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TargetType = exports.SourceType = exports.Category = exports.ActionType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let Category = exports.Category = /*#__PURE__*/function (Category) {
  Category["Endpoint"] = "endpoint";
  return Category;
}({});
let SourceType = exports.SourceType = /*#__PURE__*/function (SourceType) {
  SourceType["LlmConnector"] = "llm-connector";
  return SourceType;
}({});
let TargetType = exports.TargetType = /*#__PURE__*/function (TargetType) {
  TargetType["Endpoint"] = "endpoint";
  return TargetType;
}({});
let ActionType = exports.ActionType = /*#__PURE__*/function (ActionType) {
  ActionType["Refreshed"] = "refreshed";
  ActionType["Remediated"] = "remediated";
  ActionType["Suppressed"] = "suppressed";
  ActionType["Dismissed"] = "dismissed";
  return ActionType;
}({}); // "permanently" dismissed, cannot be normally refreshed