"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpacesPopoverList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./spaces_popover_list.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/spaces-plugin/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SpacesPopoverList extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      allowSpacesListFocus: false,
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "getMenuPanel", () => {
      const options = this.getSpaceOptions();
      const noSpacesMessage = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        className: "eui-textCenter"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.spacesPopoverList.noSpacesFoundTitle",
        defaultMessage: " no spaces found "
      }));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
        className: 'spcMenu',
        title: _i18n.i18n.translate('xpack.security.management.editRole.spacesPopoverList.popoverTitle', {
          defaultMessage: 'Spaces'
        }),
        searchable: this.props.spaces.length >= _common.SPACE_SEARCH_COUNT_THRESHOLD,
        searchProps: this.props.spaces.length >= _common.SPACE_SEARCH_COUNT_THRESHOLD ? {
          placeholder: _i18n.i18n.translate('xpack.security.management.editRole.spacesPopoverList.findSpacePlaceholder', {
            defaultMessage: 'Find a space'
          }),
          compressed: true,
          isClearable: true,
          id: 'spacesPopoverListSearch'
        } : undefined,
        noMatchesMessage: noSpacesMessage,
        options: options,
        singleSelection: true,
        style: {
          width: 300
        },
        listProps: {
          rowHeight: 40,
          showIcons: false,
          onFocusBadge: false
        }
      }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
        paddingSize: "s"
      }, _i18n.i18n.translate('xpack.security.management.editRole.spacesPopoverList.selectSpacesTitle', {
        defaultMessage: 'Spaces'
      })), search, list));
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState({
        isPopoverOpen: !this.state.isPopoverOpen
      });
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "getSpaceOptions", () => {
      const LazySpaceAvatar = /*#__PURE__*/(0, _react.memo)(this.props.spacesApiUi.components.getSpaceAvatar);
      return this.props.spaces.map(space => {
        const icon = /*#__PURE__*/_react.default.createElement(_react.Suspense, {
          fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "m"
          })
        }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
          space: space,
          size: 's',
          announceSpaceName: false
        }));
        return {
          'aria-label': space.name,
          'aria-roledescription': 'space',
          label: space.name,
          key: space.id,
          prepend: icon,
          checked: undefined,
          'data-test-subj': `${space.id}-selectableSpaceItem`,
          className: 'selectableSpaceItem'
        };
      });
    });
  }
  render() {
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: 'xs',
      onClick: this.onButtonClick
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "secSpacesPopoverList__buttonText"
    }, this.props.buttonText));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: 'spacesPopoverList',
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downLeft",
      ownFocus: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, null, this.getMenuPanel()));
  }
}
exports.SpacesPopoverList = SpacesPopoverList;