"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicenseWarningNotice = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LicenseWarningNotice = () => {
  const registerLicenseLinkLabel = _i18n.i18n.translate('xpack.searchProfiler.registerLicenseLinkLabel', {
    defaultMessage: 'register a license'
  });
  const trialLicense = _i18n.i18n.translate('xpack.searchProfiler.trialLicenseTitle', {
    defaultMessage: 'Trial'
  });
  const basicLicense = _i18n.i18n.translate('xpack.searchProfiler.basicLicenseTitle', {
    defaultMessage: 'Basic'
  });
  const goldLicense = _i18n.i18n.translate('xpack.searchProfiler.goldLicenseTitle', {
    defaultMessage: 'Gold'
  });
  const platinumLicense = _i18n.i18n.translate('xpack.searchProfiler.platinumLicenseTitle', {
    defaultMessage: 'Platinum'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__licenseWarning__container"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.searchProfiler.licenseErrorMessageTitle', {
      defaultMessage: 'License error'
    }),
    color: "danger",
    iconType: "warning",
    style: {
      padding: '16px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchProfiler.licenseErrorMessageDescription",
    defaultMessage: "The Profiler Visualization requires an active license ({licenseTypeList} or {platinumLicenseType}), but none were found in your cluster.",
    values: {
      licenseTypeList: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, trialLicense), ", ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, basicLicense), ",", ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, goldLicense)),
      platinumLicenseType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, platinumLicense)
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchProfiler.registerLicenseDescription",
    defaultMessage: "Please {registerLicenseLink} to continue using the Search Profiler",
    values: {
      registerLicenseLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/subscriptions",
        rel: "noopener"
      }, registerLicenseLinkLabel)
    }
  })))));
};
exports.LicenseWarningNotice = LicenseWarningNotice;