"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEISConnector = void 0;
var _constants = require("@kbn/stack-connectors-plugin/common/inference/constants");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isEISConnector = connector => {
  var _connector$config$pro, _connector$config, _connector$config$pro2;
  if (connector.actionTypeId !== _constants.INFERENCE_CONNECTOR_ID) return false;
  const modelId = (_connector$config$pro = (_connector$config = connector.config) === null || _connector$config === void 0 ? void 0 : (_connector$config$pro2 = _connector$config.providerConfig) === null || _connector$config$pro2 === void 0 ? void 0 : _connector$config$pro2.model_id) !== null && _connector$config$pro !== void 0 ? _connector$config$pro : undefined;
  if (modelId === _inferenceCommon.elasticModelIds.RainbowSprinkles) {
    return true;
  }
  return false;
};
exports.isEISConnector = isEISConnector;