"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAutoBottomScroll = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAutoBottomScroll = deps => {
  const ref = (0, _react.useRef)(null);
  const [isAutoScrollMode, setAutoBottomScroll] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    if (ref.current && isAutoScrollMode) {
      ref.current.scrollTop = ref.current.scrollHeight;
    }
  });
  (0, _react.useEffect)(() => {
    const currentRef = ref.current;
    const calculateAutoScroll = () => {
      if (ref.current) {
        const newIsAutoScrollMode = ref.current.scrollTop + ref.current.clientHeight === ref.current.scrollHeight;
        if (newIsAutoScrollMode !== isAutoScrollMode) {
          setAutoBottomScroll(newIsAutoScrollMode);
        }
      }
    };
    currentRef === null || currentRef === void 0 ? void 0 : currentRef.addEventListener('scroll', calculateAutoScroll);
    return () => {
      currentRef === null || currentRef === void 0 ? void 0 : currentRef.removeEventListener('scroll', calculateAutoScroll);
    };
  }, [isAutoScrollMode, deps]);
  return ref;
};
exports.useAutoBottomScroll = useAutoBottomScroll;