"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../common/doc_links");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SystemMessage = ({
  content
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: _i18n.i18n.translate('xpack.searchPlayground.chat.message.system.username', {
      defaultMessage: 'system'
    }),
    timelineAvatarAriaLabel: _i18n.i18n.translate('xpack.searchPlayground.chat.message.system.avatarAriaLabel', {
      defaultMessage: 'System'
    }),
    event: content === _common.ContextModelLimitError ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.chat.message.system.contextModelLimitError",
      defaultMessage: "{SystemMessage}: Try reducing the number of selected documents and fields to stay within context limits. {LearnMore}",
      values: {
        SystemMessage: content,
        LearnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.context,
          target: "_blank",
          "data-test-subj": "system-contentModelLimit-learnMore-documentation-link"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.searchPlayground.chat.message.system.contextModelLimitError.LearnMore",
          defaultMessage: "Learn more"
        }))
      }
    }))) : content,
    timelineAvatar: "dot",
    eventColor: "subdued",
    css: {
      '.euiAvatar': {
        backgroundColor: euiTheme.colors.emptyShade
      },
      '.euiCommentEvent': {
        border: euiTheme.border.thin,
        borderRadius: euiTheme.border.radius.medium
      }
    },
    "data-test-subj": "systemMessage"
  });
};
exports.SystemMessage = SystemMessage;