"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeBox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _tryInConsole = require("@kbn/try-in-console");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _language = require("../../utils/language");
var Styles = _interopRequireWildcard(require("./styles"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CodeBox = props => {
  var _selectedOption$code;
  const {
    consoleCode,
    options,
    showTopBar = true
  } = props;
  const dataTestSubj = props['data-test-subj'];
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    application,
    console: consolePlugin,
    share: sharePlugin
  } = (0, _public.useKibana)().services;
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [selectedLangId, setSelectedLanguage] = (0, _react.useState)(_language.getDefaultCodingLanguage);
  const selectedOption = (0, _react.useMemo)(() => {
    var _options$find;
    return (_options$find = options.find(opt => opt.language.id === selectedLangId)) !== null && _options$find !== void 0 ? _options$find : null;
  }, [selectedLangId, options]);
  const langItems = (0, _react.useMemo)(() => options.map(({
    language
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: language.id,
    icon: `${assetBasePath}/${language.icon}`,
    "aria-label": _i18n.i18n.translate('xpack.searchIndices.codeBox.languageMenu.item.ariaLabel', {
      defaultMessage: 'Change language to {languageName} for this code example',
      values: {
        languageName: language.title
      }
    }),
    onClick: () => {
      if (setSelectedLanguage) {
        setSelectedLanguage(language.id);
        setIsPopoverOpen(false);
      }
    }
  }, language.title)), [options, assetBasePath]);
  const codeSnippet = (_selectedOption$code = selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.code) !== null && _selectedOption$code !== void 0 ? _selectedOption$code : '';
  const languageButton = selectedOption ? /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": dataTestSubj ? `${dataTestSubj}-select-lang-button` : 'code-box-select-lang-button',
    "aria-label": _i18n.i18n.translate('xpack.searchIndices.codeBox.languageSelect.ariaLabel', {
      defaultMessage: 'Select a programming language for the code snippet {languageName}',
      values: {
        languageName: selectedOption.language.title
      }
    }),
    color: "text",
    iconType: "arrowDown",
    iconSide: "left",
    onClick: () => setIsPopoverOpen(!isPopoverOpen)
  }, selectedOption.language.title)) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xs",
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'codeBlockControlsPanel',
    css: Styles.CodeBoxPanel(euiTheme)
  }, showTopBar && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s",
    justifyContent: options.length !== 0 ? 'spaceBetween' : 'flexEnd'
  }, options && languageButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "light"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: languageButton,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: langItems,
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: codeSnippet
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": dataTestSubj ? `${dataTestSubj}-copy-code-btn` : 'copy-code-btn',
    color: "text",
    iconType: "copyClipboard",
    size: "s",
    onClick: copy,
    "aria-label": _i18n.i18n.translate('xpack.searchIndices.codeBox.copyCode.ariaLabel', {
      defaultMessage: 'Copy the code snippet'
    })
  }, _i18n.i18n.translate('xpack.searchIndices.codeBox.copyButtonLabel', {
    defaultMessage: 'Copy'
  })))), consoleCode !== undefined && sharePlugin && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
    request: consoleCode,
    application: application,
    consolePlugin: consolePlugin,
    sharePlugin: sharePlugin,
    "data-test-subj": `${dataTestSubj}-run-in-console-btn`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: !showTopBar,
    transparentBackground: true,
    fontSize: "m",
    language: (selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.language.codeBlockLanguage) || 'text',
    overflowHeight: 500,
    css: Styles.CodeBoxCodeBlock
  }, codeSnippet)));
};
exports.CodeBox = CodeBox;