"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SCHEMA_SEARCH_V8_8_0 = exports.SCHEMA_SEARCH_MODEL_VERSION_5 = exports.SCHEMA_SEARCH_MODEL_VERSION_4 = exports.SCHEMA_SEARCH_MODEL_VERSION_3 = exports.SCHEMA_SEARCH_MODEL_VERSION_2 = exports.SCHEMA_SEARCH_MODEL_VERSION_1 = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SCHEMA_SEARCH_BASE = _configSchema.schema.object({
  // General
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string({
    defaultValue: ''
  }),
  // Data grid
  columns: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: []
  }),
  sort: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 2
  })), _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 2
  })], {
    defaultValue: []
  }),
  grid: _configSchema.schema.object({
    columns: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
      width: _configSchema.schema.maybe(_configSchema.schema.number())
    })))
  }, {
    defaultValue: {}
  }),
  rowHeight: _configSchema.schema.maybe(_configSchema.schema.number()),
  rowsPerPage: _configSchema.schema.maybe(_configSchema.schema.number()),
  // Chart
  hideChart: _configSchema.schema.boolean({
    defaultValue: false
  }),
  breakdownField: _configSchema.schema.maybe(_configSchema.schema.string()),
  // Search
  kibanaSavedObjectMeta: _configSchema.schema.object({
    searchSourceJSON: _configSchema.schema.string()
  }),
  isTextBasedQuery: _configSchema.schema.boolean({
    defaultValue: false
  }),
  usesAdHocDataView: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  // Time
  timeRestore: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  timeRange: _configSchema.schema.maybe(_configSchema.schema.object({
    from: _configSchema.schema.string(),
    to: _configSchema.schema.string()
  })),
  refreshInterval: _configSchema.schema.maybe(_configSchema.schema.object({
    pause: _configSchema.schema.boolean(),
    value: _configSchema.schema.number()
  })),
  // Display
  viewMode: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_common.VIEW_MODE.DOCUMENT_LEVEL), _configSchema.schema.literal(_common.VIEW_MODE.AGGREGATED_LEVEL)])),
  hideAggregatedPreview: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  // Legacy
  hits: _configSchema.schema.maybe(_configSchema.schema.number()),
  version: _configSchema.schema.maybe(_configSchema.schema.number())
});
const SCHEMA_SEARCH_V8_8_0 = exports.SCHEMA_SEARCH_V8_8_0 = SCHEMA_SEARCH_BASE;
const SCHEMA_SEARCH_MODEL_VERSION_1 = exports.SCHEMA_SEARCH_MODEL_VERSION_1 = SCHEMA_SEARCH_BASE.extends({
  sampleSize: _configSchema.schema.maybe(_configSchema.schema.number({
    min: _common.MIN_SAVED_SEARCH_SAMPLE_SIZE,
    max: _common.MAX_SAVED_SEARCH_SAMPLE_SIZE
  }))
});
const SCHEMA_SEARCH_MODEL_VERSION_2 = exports.SCHEMA_SEARCH_MODEL_VERSION_2 = SCHEMA_SEARCH_MODEL_VERSION_1.extends({
  headerRowHeight: _configSchema.schema.maybe(_configSchema.schema.number())
});
const SCHEMA_SEARCH_MODEL_VERSION_3 = exports.SCHEMA_SEARCH_MODEL_VERSION_3 = SCHEMA_SEARCH_MODEL_VERSION_2.extends({
  visContext: _configSchema.schema.maybe(_configSchema.schema.oneOf([
  // existing value
  _configSchema.schema.object({
    // unified histogram state
    suggestionType: _configSchema.schema.string(),
    requestData: _configSchema.schema.object({
      dataViewId: _configSchema.schema.maybe(_configSchema.schema.string()),
      timeField: _configSchema.schema.maybe(_configSchema.schema.string()),
      timeInterval: _configSchema.schema.maybe(_configSchema.schema.string()),
      breakdownField: _configSchema.schema.maybe(_configSchema.schema.string())
    }),
    // lens attributes
    attributes: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())
  }),
  // cleared previous value
  _configSchema.schema.object({})]))
});
const SCHEMA_SEARCH_MODEL_VERSION_4 = exports.SCHEMA_SEARCH_MODEL_VERSION_4 = SCHEMA_SEARCH_MODEL_VERSION_3.extends({
  viewMode: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_common.VIEW_MODE.DOCUMENT_LEVEL), _configSchema.schema.literal(_common.VIEW_MODE.PATTERN_LEVEL), _configSchema.schema.literal(_common.VIEW_MODE.AGGREGATED_LEVEL)]))
});
const SCHEMA_SEARCH_MODEL_VERSION_5 = exports.SCHEMA_SEARCH_MODEL_VERSION_5 = SCHEMA_SEARCH_MODEL_VERSION_4.extends({
  density: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('compact'), _configSchema.schema.literal('normal'), _configSchema.schema.literal('expanded')]))
});