"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerBulkDeleteRoute = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerBulkDeleteRoute = router => {
  router.post({
    path: '/internal/kibana/management/saved_objects/_bulk_delete',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization'
      }
    },
    validate: {
      body: _configSchema.schema.arrayOf(_configSchema.schema.object({
        type: _configSchema.schema.string(),
        id: _configSchema.schema.string()
      }))
    }
  }, router.handleLegacyErrors(async (context, req, res) => {
    const {
      getClient
    } = (await context.core).savedObjects;
    const objects = req.body;
    const client = getClient();
    const response = await client.bulkDelete(objects, {
      force: true
    });
    const body = response.statuses;
    return res.ok({
      body
    });
  }));
};
exports.registerBulkDeleteRoute = registerBulkDeleteRoute;