"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportInfoFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reportingPublic = require("@kbn/reporting-public");
var _inspect_in_console_button = require("./inspect_in_console_button/inspect_in_console_button");
var _report_info_flyout_content = require("./report_info_flyout_content");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReportInfoFlyout = ({
  config,
  onClose,
  job
}) => {
  var _info$title;
  const isMounted = (0, _useMountedState.default)();
  const {
    apiClient
  } = (0, _reportingPublic.useInternalApiClient)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [loadingError, setLoadingError] = (0, _react.useState)();
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const [info, setInfo] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    async function loadInfo() {
      if (isLoading) {
        try {
          const infoResponse = await apiClient.getInfo(job.id);
          if (isMounted()) {
            setInfo(infoResponse);
          }
        } catch (err) {
          if (isMounted()) {
            setLoadingError(err);
          }
        } finally {
          if (isMounted()) {
            setIsLoading(false);
          }
        }
      }
    }
    loadInfo();
  }, [isLoading, apiClient, job.id, isMounted]);
  const actionsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "reportInfoFlyoutActionsButton",
    iconType: "arrowUp",
    onClick: () => setIsActionsPopoverOpen(isOpen => !isOpen)
  }, _i18n.i18n.translate('xpack.reporting.reportInfoFlyout.actionsButtonLabel', {
    defaultMessage: 'Actions'
  }));
  const actionItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "reportInfoFlyoutDownloadButton",
    key: "download",
    icon: "download",
    disabled: !job.isDownloadReady,
    onClick: () => {
      apiClient.downloadReport(job.id);
    }
  }, _i18n.i18n.translate('xpack.reporting.reportInfoFlyout.downloadButtonLabel', {
    defaultMessage: 'Download'
  })), /*#__PURE__*/_react.default.createElement(_inspect_in_console_button.InspectInConsoleButton, {
    job: job,
    config: config
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "reportInfoFlyoutOpenInKibanaButton",
    disabled: !job.canLinkToKibanaApp,
    key: "openInKibanaApp",
    icon: "popout",
    onClick: () => {
      window.open(apiClient.getKibanaAppHref(job), '_blank');
      window.focus();
    }
  }, _i18n.i18n.translate('xpack.reporting.reportInfoFlyout.openInKibanaAppButtonLabel', {
    defaultMessage: 'Open in Kibana'
  }))].filter(Boolean);
  const closePopover = () => setIsActionsPopoverOpen(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    size: "s",
    "aria-labelledby": "flyoutTitle",
    "data-test-subj": "reportInfoFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutTitle"
  }, loadingError ? _i18n.i18n.translate('xpack.reporting.listing.table.reportInfoUnableToFetch', {
    defaultMessage: 'Unable to fetch report info.'
  }) : (_info$title = info === null || info === void 0 ? void 0 : info.title) !== null && _info$title !== void 0 ? _info$title : _i18n.i18n.translate('xpack.reporting.listing.table.untitledReport', {
    defaultMessage: 'Untitled report'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : loadingError ? undefined : !!info ? /*#__PURE__*/_react.default.createElement(_report_info_flyout_content.ReportInfoFlyoutContent, {
    info: info,
    config: config
  }) : undefined), !isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: onClose
  }, _i18n.i18n.translate('xpack.reporting.listing.flyout.closeButtonLabel', {
    defaultMessage: 'Close'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "reportInfoFlyoutActionsPopover",
    button: actionsButton,
    isOpen: isActionsPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: actionItems
  })))))));
};
exports.ReportInfoFlyout = ReportInfoFlyout;