"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("./utils");
var _default_provider = require("./default_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AgentsService {
  constructor() {
    (0, _defineProperty2.default)(this, "setupDeps", void 0);
  }
  setup(setupDeps) {
    this.setupDeps = setupDeps;
    return {};
  }
  start(startDeps) {
    if (!this.setupDeps) {
      throw new Error('#start called before #setup');
    }
    const {
      getRunner
    } = startDeps;
    const defaultAgentProvider = (0, _default_provider.createDefaultAgentProvider)();
    const registry = (0, _utils.createInternalRegistry)({
      providers: [defaultAgentProvider],
      getRunner
    });
    return {
      registry,
      execute: async args => {
        return getRunner().runAgent(args);
      }
    };
  }
}
exports.AgentsService = AgentsService;