"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHandlerWrapper = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHandlerWrapper = ({
  logger
}) => handler => {
  return (ctx, req, res) => {
    try {
      return handler(ctx, req, res);
    } catch (e) {
      if ((0, _onechatCommon.isOnechatError)(e)) {
        var _e$meta$statusCode, _e$meta;
        logger.error(e);
        return res.customError({
          body: {
            message: e.message
          },
          statusCode: (_e$meta$statusCode = (_e$meta = e.meta) === null || _e$meta === void 0 ? void 0 : _e$meta.statusCode) !== null && _e$meta$statusCode !== void 0 ? _e$meta$statusCode : 500
        });
      } else {
        throw e;
      }
    }
  };
};
exports.getHandlerWrapper = getHandlerWrapper;