"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeZone = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimeZone = () => {
  const timeZone = (0, _public.useUiSetting)('dateFormat:tz');
  const localTZ = _momentTimezone.default.tz.guess();
  if (!timeZone || timeZone === 'Browser') {
    return localTZ;
  }
  return timeZone;
};
exports.useTimeZone = useTimeZone;