"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onBrushEnd = void 0;
var _url = require("../../../utils/url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onBrushEnd = ({
  x,
  history
}) => {
  if (x) {
    const start = x[0];
    const end = x[1];
    const currentSearch = (0, _url.toQuery)(history.location.search);
    const nextSearch = {
      rangeFrom: new Date(start).toISOString(),
      rangeTo: new Date(end).toISOString()
    };
    history.push({
      ...history.location,
      search: (0, _url.fromQuery)({
        ...currentSearch,
        ...nextSearch
      })
    });
  }
};
exports.onBrushEnd = onBrushEnd;