"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAnnotation = getDefaultAnnotation;
var _moment = _interopRequireDefault(require("moment"));
var _eventAnnotationCommon = require("@kbn/event-annotation-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultAnnotation({
  slo,
  timestamp,
  eventEnd
}) {
  const sloId = slo === null || slo === void 0 ? void 0 : slo.id;
  const sloInstanceId = slo === null || slo === void 0 ? void 0 : slo.instanceId;
  return {
    message: eventEnd ? _eventAnnotationCommon.defaultRangeAnnotationLabel : _eventAnnotationCommon.defaultAnnotationLabel,
    '@timestamp': timestamp !== null && timestamp !== void 0 ? timestamp : (0, _moment.default)(),
    event: {
      start: timestamp,
      end: eventEnd
    },
    annotation: {
      title: eventEnd ? _eventAnnotationCommon.defaultRangeAnnotationLabel : _eventAnnotationCommon.defaultAnnotationLabel,
      style: {
        icon: 'triangle',
        color: eventEnd ? _eventAnnotationCommon.defaultAnnotationRangeColor : _eventAnnotationCommon.defaultAnnotationColor,
        line: {
          width: 2,
          style: 'solid',
          textDecoration: 'name'
        },
        rect: {
          fill: 'inside'
        }
      }
    },
    ...(sloId ? {
      slo: {
        id: sloId,
        instanceId: sloInstanceId
      }
    } : {})
  };
}