"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudDeployment = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _legacy_shims = require("../../../legacy_shims");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CloudDeployment = () => {
  const {
    ELASTIC_WEBSITE_URL
  } = _legacy_shims.Legacy.shims.docLinks;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.blurbs.cloudDeploymentDescription",
    defaultMessage: "Configure monitoring through "
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://cloud.elastic.co/deployments",
    target: "_blank"
  }, "Elasticsearch Service Console"), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.blurbs.cloudDeploymentDescription2",
    defaultMessage: "Go to "
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://cloud.elastic.co/deployments",
    target: "_blank"
  }, "Logs and metrics"), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.blurbs.cloudDeploymentDescription3",
    defaultMessage: "section for a deployment to configure monitoring. For more information visit "
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${ELASTIC_WEBSITE_URL}guide/en/cloud/current/ec-enable-logging-and-monitoring.html`,
    target: "_blank"
  }, "the documentation page."))));
};
exports.CloudDeployment = CloudDeployment;