"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCategorizationADJobAction = createCategorizationADJobAction;
exports.createCategorizationADJobTrigger = void 0;
var _i18n = require("@kbn/i18n");
var _mlUiActions = require("@kbn/ml-ui-actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createCategorizationADJobTrigger = exports.createCategorizationADJobTrigger = {
  id: _mlUiActions.CREATE_PATTERN_ANALYSIS_TO_ML_AD_JOB_TRIGGER,
  title: _i18n.i18n.translate('xpack.ml.actions.createADJobFromPatternAnalysis', {
    defaultMessage: 'Create categorization anomaly detection job'
  }),
  description: _i18n.i18n.translate('xpack.ml.actions.createADJobFromPatternAnalysis', {
    defaultMessage: 'Create categorization anomaly detection job'
  })
};
function createCategorizationADJobAction(getStartServices) {
  return {
    id: 'create-ml-categorization-ad-job-action',
    type: _mlUiActions.CREATE_PATTERN_ANALYSIS_TO_ML_AD_JOB_ACTION,
    getIconType(context) {
      return 'machineLearningApp';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.actions.createADJobFromPatternAnalysis', {
      defaultMessage: 'Create categorization anomaly detection job'
    }),
    async execute({
      dataView,
      field,
      query,
      timeRange
    }) {
      if (!dataView) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      try {
        const [{
          showPatternAnalysisToADJobFlyout
        }, [coreStart, {
          share,
          data,
          dashboard
        }]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/job_creation/aiops'))), getStartServices()]);
        await showPatternAnalysisToADJobFlyout(dataView, field, query, timeRange, coreStart, share, data, dashboard);
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible({
      dataView,
      field
    }) {
      return dataView.timeFieldName !== undefined && dataView.fields.find(f => f.name === field.name) !== undefined;
    }
  };
}