"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.singleMetricRouteFactory = exports.rareRouteFactory = exports.populationRouteFactory = exports.multiMetricRouteFactoryRedirect = exports.multiMetricRouteFactory = exports.geoRouteFactory = exports.categorizationRouteFactory = exports.advancedRouteFactoryRedirect = exports.advancedRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _queryString = require("query-string");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _data_source_context = require("../../../contexts/ml/data_source_context");
var _kibana = require("../../../contexts/kibana");
var _resolvers = require("../../resolvers");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _new_job = require("../../../../../common/constants/new_job");
var _load_new_job_capabilities = require("../../../services/new_job_capabilities/load_new_job_capabilities");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _breadcrumbs = require("../../breadcrumbs");
var _use_create_url = require("../../../contexts/kibana/use_create_url");
var _locator = require("../../../../../common/constants/locator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Page = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../jobs/new_job/pages/new_job')))).Page
}));
const getBaseBreadcrumbs = navigateToApp => [(0, _breadcrumbs.getStackManagementBreadcrumb)(navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('ANOMALY_DETECTION_MANAGEMENT_BREADCRUMB', navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('CREATE_JOB_MANAGEMENT_BREADCRUMB', navigateToApp)];
const getSingleMetricBreadcrumbs = navigateToApp => [...getBaseBreadcrumbs(navigateToApp), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.singleMetricLabel', {
    defaultMessage: 'Single metric'
  }),
  href: ''
}];
const getMultiMetricBreadcrumbs = navigateToApp => [...getBaseBreadcrumbs(navigateToApp), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.multiMetricLabel', {
    defaultMessage: 'Multi-metric'
  }),
  href: ''
}];
const getPopulationBreadcrumbs = navigateToApp => [...getBaseBreadcrumbs(navigateToApp), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.populationLabel', {
    defaultMessage: 'Population'
  }),
  href: ''
}];
const getAdvancedBreadcrumbs = navigateToApp => [...getBaseBreadcrumbs(navigateToApp), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.advancedConfigurationLabel', {
    defaultMessage: 'Advanced configuration'
  }),
  href: ''
}];
const getCategorizationBreadcrumbs = navigateToApp => [...getBaseBreadcrumbs(navigateToApp), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.categorizationLabel', {
    defaultMessage: 'Categorization'
  }),
  href: ''
}];
const getRareBreadcrumbs = navigateToApp => [...getBaseBreadcrumbs(navigateToApp), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.rareLabel', {
    defaultMessage: 'Rare'
  }),
  href: ''
}];
const getGeoBreadcrumbs = navigateToApp => [...getBaseBreadcrumbs(navigateToApp), {
  text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.geoLabel', {
    defaultMessage: 'Geo'
  }),
  href: ''
}];
const singleMetricRouteFactory = navigateToApp => {
  return {
    path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SINGLE_METRIC),
    render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
      jobType: _new_job.JOB_TYPE.SINGLE_METRIC,
      deps: deps
    })),
    breadcrumbs: getSingleMetricBreadcrumbs(navigateToApp)
  };
};
exports.singleMetricRouteFactory = singleMetricRouteFactory;
const multiMetricRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_MULTI_METRIC),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    jobType: _new_job.JOB_TYPE.MULTI_METRIC,
    deps: deps
  })),
  breadcrumbs: getMultiMetricBreadcrumbs(navigateToApp)
});

// redirect route to reset the job wizard when converting to multi metric job
exports.multiMetricRouteFactory = multiMetricRouteFactory;
const multiMetricRouteFactoryRedirect = () => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_CONVERT_TO_MULTI_METRIC),
  render: props => {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_MULTI_METRIC, props.location.search)
    });
  },
  breadcrumbs: []
});
exports.multiMetricRouteFactoryRedirect = multiMetricRouteFactoryRedirect;
const populationRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_POPULATION),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    jobType: _new_job.JOB_TYPE.POPULATION,
    deps: deps
  })),
  breadcrumbs: getPopulationBreadcrumbs(navigateToApp)
});
exports.populationRouteFactory = populationRouteFactory;
const advancedRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_ADVANCED),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    jobType: _new_job.JOB_TYPE.ADVANCED,
    deps: deps
  })),
  breadcrumbs: getAdvancedBreadcrumbs(navigateToApp)
});

// redirect route to reset the job wizard when converting to advanced job
exports.advancedRouteFactory = advancedRouteFactory;
const advancedRouteFactoryRedirect = () => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_CONVERT_TO_ADVANCED),
  render: props => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_ADVANCED, props.location.search)
  }),
  breadcrumbs: []
});
exports.advancedRouteFactoryRedirect = advancedRouteFactoryRedirect;
const categorizationRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_CATEGORIZATION),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    jobType: _new_job.JOB_TYPE.CATEGORIZATION,
    deps: deps
  })),
  breadcrumbs: getCategorizationBreadcrumbs(navigateToApp)
});
exports.categorizationRouteFactory = categorizationRouteFactory;
const rareRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_RARE),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    jobType: _new_job.JOB_TYPE.RARE,
    deps: deps
  })),
  breadcrumbs: getRareBreadcrumbs(navigateToApp)
});
exports.rareRouteFactory = rareRouteFactory;
const geoRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_GEO),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    jobType: _new_job.JOB_TYPE.GEO,
    deps: deps
  })),
  breadcrumbs: getGeoBreadcrumbs(navigateToApp)
});
exports.geoRouteFactory = geoRouteFactory;
const PageWrapper = ({
  location,
  jobType
}) => {
  const redirectToJobsManagementPage = (0, _use_create_url.useCreateAndNavigateToMlLink)(_locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE);
  const {
    index,
    savedSearchId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    services: {
      data: {
        dataViews: dataViewsService
      },
      savedSearch: savedSearchService,
      mlServices: {
        mlApi
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    context,
    results
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs', 'canCreateJob'], {
    ...(0, _resolvers.basicResolvers)(),
    // TODO useRouteResolver should be responsible for the redirect
    privileges: () => (0, _check_capabilities.checkCreateJobsCapabilitiesResolver)(mlApi, redirectToJobsManagementPage),
    jobCaps: () => (0, _load_new_job_capabilities.loadNewJobCapabilities)(index, savedSearchId, mlApi, dataViewsService, savedSearchService, _load_new_job_capabilities.ANOMALY_DETECTOR),
    existingJobsAndGroups: () => mlApi.jobs.getAllJobAndGroupIds()
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_data_source_context.DataSourceContextProvider, null, results ? /*#__PURE__*/_react.default.createElement(Page, {
    jobType: jobType,
    existingJobsAndGroups: results.existingJobsAndGroups
  }) : null));
};