"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPipelineConfig = getPipelineConfig;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPipelineConfig(state) {
  var _initialPipelineConfi;
  const {
    ignoreFailure,
    modelId,
    onFailure,
    pipelineDescription,
    initialPipelineConfig
  } = state;
  const processor = initialPipelineConfig !== null && initialPipelineConfig !== void 0 && initialPipelineConfig.processors && (_initialPipelineConfi = initialPipelineConfig.processors) !== null && _initialPipelineConfi !== void 0 && _initialPipelineConfi.length ? initialPipelineConfig === null || initialPipelineConfig === void 0 ? void 0 : initialPipelineConfig.processors[0] : {};
  return {
    description: pipelineDescription,
    processors: [{
      inference: {
        ...(processor !== null && processor !== void 0 && processor.inference ? {
          ...processor.inference,
          ignore_failure: ignoreFailure,
          ...(onFailure && Object.keys(onFailure).length > 0 ? {
            on_failure: onFailure
          } : {
            on_failure: undefined
          })
        } : {}),
        model_id: modelId
      }
    }]
  };
}