"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_MODAL_WIDTH = 1200;
const ModalWrapper = ({
  onCreateClick,
  closeModal,
  saveEnabled,
  children
}) => {
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'mlCreateDetectorModalTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    maxWidth: MAX_MODAL_WIDTH,
    "data-test-subj": "mlCreateDetectorModal",
    "aria-labelledby": titleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: titleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.title",
    defaultMessage: "Create detector"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, children), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    "data-test-subj": "mlCreateDetectorModalCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.cancelButton",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onCreateClick,
    isDisabled: saveEnabled === false,
    fill: true,
    "data-test-subj": "mlCreateDetectorModalSaveButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.advancedDetectorModal.saveButton",
    defaultMessage: "Save"
  }))));
};
exports.ModalWrapper = ModalWrapper;