"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDriftPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../contexts/kibana");
var _ml = require("../../contexts/ml");
var _page_header = require("../../components/page_header");
var _technical_preview_badge = require("../../components/technical_preview_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataDriftPage = () => {
  const {
    services: {
      dataVisualizer
    }
  } = (0, _kibana.useMlKibana)();
  const [DataDriftView, setDataDriftView] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (dataVisualizer !== undefined) {
      const {
        getDataDriftComponent
      } = dataVisualizer;
      getDataDriftComponent().then(setDataDriftView);
    }
  }, [dataVisualizer]);
  const {
    selectedDataView: dataView,
    selectedSavedSearch: savedSearch
  } = (0, _ml.useDataSource)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'center',
    gutterSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataDruiftWithDocCount.pageHeader",
    defaultMessage: "Data drift"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, null)))), dataView && DataDriftView ? /*#__PURE__*/_react.default.createElement(DataDriftView, {
    dataView: dataView,
    savedSearch: savedSearch
  }) : null);
};
exports.DataDriftPage = DataDriftPage;