"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddInferencePipelineFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../ml_inference/constants");
var _get_steps = require("../ml_inference/get_steps");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddInferencePipelineFooter = ({
  isDetailsStepValid,
  isConfigureProcessorStepValid,
  creatingPipeline,
  pipelineCreated,
  onClose,
  onCreate,
  step,
  setStep,
  hasProcessorStep
}) => {
  const {
    nextStep,
    previousStep,
    isContinueButtonEnabled
  } = (0, _react.useMemo)(() => (0, _get_steps.getSteps)(step, isDetailsStepValid, isConfigureProcessorStepValid, hasProcessorStep), [isDetailsStepValid, isConfigureProcessorStepValid, step, hasProcessorStep]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "mlTrainedModelsInferencePipelineCloseButton"
  }, pipelineCreated ? _constants.CLOSE_BUTTON_LABEL : _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, previousStep !== undefined && pipelineCreated === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    iconType: "arrowLeft",
    onClick: () => setStep(previousStep)
  }, _constants.BACK_BUTTON_LABEL) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, nextStep !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlTrainedModelsInferencePipelineContinueButton",
    iconType: "arrowRight",
    iconSide: "right",
    onClick: () => setStep(nextStep),
    disabled: !isContinueButtonEnabled,
    fill: true
  }, _constants.CONTINUE_BUTTON_LABEL) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlTrainedModelsInferencePipelineCreateButton",
    color: "success",
    disabled: !isContinueButtonEnabled || creatingPipeline || pipelineCreated,
    fill: true,
    onClick: onCreate,
    isLoading: creatingPipeline
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.addInferencePipelineModal.footer.create', {
    defaultMessage: 'Create pipeline'
  }))));
};
exports.AddInferencePipelineFooter = AddInferencePipelineFooter;