"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisplayPanel = DisplayPanel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mb_validated_color_picker = require("../../classes/styles/vector/components/color/mb_validated_color_picker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROJECTION_OPTIONS = [{
  value: 'globeInterpolate',
  text: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.projection.globeLabel', {
    defaultMessage: 'Globe'
  })
}, {
  value: 'mercator',
  text: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.projection.mercatorLabel', {
    defaultMessage: 'Mercator'
  })
}];
function DisplayPanel({
  settings,
  updateMapSetting
}) {
  const onBackgroundColorChange = color => {
    updateMapSetting('backgroundColor', color);
  };
  const onProjectionChange = event => {
    updateMapSetting('projection', event.target.value);
  };
  const onShowScale = event => {
    updateMapSetting('showScaleControl', event.target.checked);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.mapSettingsPanel.displayTitle",
    defaultMessage: "Display"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.backgroundColorLabel', {
      defaultMessage: 'Background color'
    }),
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(_mb_validated_color_picker.MbValidatedColorPicker, {
    color: settings.backgroundColor,
    onChange: onBackgroundColorChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.projectionLabel', {
      defaultMessage: 'Projection'
    }),
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: PROJECTION_OPTIONS,
    value: settings.projection,
    onChange: onProjectionChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.showScaleLabel', {
      defaultMessage: 'Show scale'
    }),
    checked: settings.showScaleControl,
    onChange: onShowScale,
    compressed: true
  })));
}