"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compareTimeKeys = compareTimeKeys;
exports.compareToTimeKey = void 0;
var _d3Array = require("d3-array");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function compareTimeKeys(firstKey, secondKey, compareValues = _d3Array.ascending) {
  const timeComparison = compareValues(firstKey.time, secondKey.time);
  if (timeComparison === 0) {
    const tiebreakerComparison = compareValues(firstKey.tiebreaker, secondKey.tiebreaker);
    if (tiebreakerComparison === 0 && typeof firstKey.gid !== 'undefined' && typeof secondKey.gid !== 'undefined') {
      return compareValues(firstKey.gid, secondKey.gid);
    }
    return tiebreakerComparison;
  }
  return timeComparison;
}
const compareToTimeKey = (keyAccessor, compareValues) => (value, key) => compareTimeKeys(keyAccessor(value), key, compareValues);
exports.compareToTimeKey = compareToTimeKey;