"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagEnhancedSavedObjectSaveModalOrigin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/saved-objects-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TagEnhancedSavedObjectSaveModalOrigin = ({
  initialTags,
  onSave,
  savedObjectsTagging,
  options,
  ...otherProps
}) => {
  const [selectedTags, setSelectedTags] = (0, _react.useState)(initialTags);
  const tagSelectorOption = (0, _react.useMemo)(() => savedObjectsTagging ? /*#__PURE__*/_react.default.createElement(savedObjectsTagging.ui.components.SavedObjectSaveModalTagSelector, {
    initialSelection: initialTags,
    onTagsSelected: setSelectedTags
  }) : undefined, [savedObjectsTagging, initialTags]);
  const tagEnhancedOptions = typeof options === 'function' ? state => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tagSelectorOption, options(state));
  } : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tagSelectorOption, options);
  const tagEnhancedOnSave = (0, _react.useCallback)(async saveOptions => {
    await onSave({
      ...saveOptions,
      newTags: selectedTags
    });
    return {}; // SaveResult return type not needed here
  }, [onSave, selectedTags]);
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModalOrigin, (0, _extends2.default)({}, otherProps, {
    onSave: tagEnhancedOnSave,
    options: tagEnhancedOptions
  }));
};
exports.TagEnhancedSavedObjectSaveModalOrigin = TagEnhancedSavedObjectSaveModalOrigin;