"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNextTab = getNextTab;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getNextTab(currentTab, tabs, preferredTabs) {
  const firstTab = tabs.length ? tabs[0] : null;
  if (currentTab || !preferredTabs) {
    return firstTab;
  }
  const preferredTabName = preferredTabs.find(tabName => {
    return tabs.some(({
      name
    }) => tabName.toLowerCase() === name.toLowerCase());
  });
  const preferredTab = preferredTabName ? tabs.find(({
    name
  }) => preferredTabName.toLowerCase() === name.toLowerCase()) : undefined;
  return preferredTab ? preferredTab : firstTab;
}