"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestPipelineFlyoutWithContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/es-ui-shared-plugin/public");
var _locator = require("../../../locator");
var _constants = require("../../../../common/constants");
var _shared_imports = require("../../../shared_imports");
var _delete_modal = require("./delete_modal");
var _pipeline_flyout = require("./pipeline_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IngestPipelineFlyoutWithContext = ({
  coreServices,
  services,
  ingestPipelineName,
  onClose,
  reload
}) => {
  const locator = services.share.url.locators.get(_locator.INGEST_PIPELINES_APP_LOCATOR);
  const editPipeline = (0, _react.useCallback)(name => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      page: _locator.INGEST_PIPELINES_PAGES.EDIT,
      pipelineId: name
    });
  }, [locator]);
  const clonePipeline = (0, _react.useCallback)(name => {
    locator === null || locator === void 0 ? void 0 : locator.navigate({
      page: _locator.INGEST_PIPELINES_PAGES.CLONE,
      pipelineId: name
    });
  }, [locator]);
  const [pipelinesToDelete, setPipelinesToDelete] = (0, _react.useState)([]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaRenderContextProvider, coreServices, /*#__PURE__*/_react.default.createElement(_public.AuthorizationProvider, {
    privilegesEndpoint: `${_constants.API_BASE_PATH}/privileges/ingest_pipelines`,
    httpClient: coreServices.http
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_pipeline_flyout.PipelineFlyout, {
    embedded: true,
    pipeline: ingestPipelineName,
    onClose: onClose,
    onEditClick: editPipeline,
    onCloneClick: clonePipeline,
    onDeleteClick: pipelines => setPipelinesToDelete(pipelines)
  }), (pipelinesToDelete === null || pipelinesToDelete === void 0 ? void 0 : pipelinesToDelete.length) > 0 ? /*#__PURE__*/_react.default.createElement(_delete_modal.PipelineDeleteModal, {
    callback: () => {
      onClose();
      reload();
      setPipelinesToDelete([]);
    },
    pipelinesToDelete: pipelinesToDelete
  }) : null)));
};
exports.IngestPipelineFlyoutWithContext = IngestPipelineFlyoutWithContext;