"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateIndexName = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _field_name_field = require("./common_fields/field_name_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  /* Required fields config */
  date_rounding: {
    type: _shared_imports.FIELD_TYPES.SELECT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateRoundingFieldLabel', {
      defaultMessage: 'Date rounding'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateRoundingFieldHelpText', {
      defaultMessage: 'Time period used to round the date when formatting the date into the index name.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateRoundingRequiredError', {
        defaultMessage: 'A date rounding value is required.'
      }))
    }]
  },
  /* Optional fields config */
  index_name_prefix: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.indexNamePrefixFieldLabel', {
      defaultMessage: 'Index name prefix (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.indexNamePrefixFieldHelpText', {
      defaultMessage: 'Prefix to add before the printed date in the index name.'
    })
  },
  index_name_format: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.indexNameFormatFieldLabel', {
      defaultMessage: 'Index name format (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.indexNameFormatFieldHelpText",
      defaultMessage: "Date format used to print the parsed date into the index name. Defaults to {value}.",
      values: {
        value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'yyyy-MM-dd')
      }
    })
  },
  date_formats: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    serializer: v => {
      return v.length ? v : undefined;
    },
    deserializer: _shared.to.arrayOfStrings,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateFormatsFieldLabel', {
      defaultMessage: 'Date formats (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateFormatsHelpText",
      defaultMessage: "Expected date formats. Provided formats are applied sequentially. Accepts a Java time pattern, ISO8601, UNIX, UNIX_MS, or TAI64N formats. Defaults to {value}.",
      values: {
        value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "yyyy-MM-dd'T'HH:mm:ss.SSSXX")
      }
    })
  },
  timezone: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.timezoneFieldLabel', {
      defaultMessage: 'Timezone (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.timezoneHelpText",
      defaultMessage: "Timezone used when parsing the date and constructing the index name expression. Defaults to {timezone}.",
      values: {
        timezone: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'UTC')
      }
    })
  },
  locale: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.localeFieldLabel', {
      defaultMessage: 'Locale (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.dateIndexForm.localeHelpText",
      defaultMessage: "Locale to use when parsing the date. Useful when parsing month or day names. Defaults to {locale}.",
      values: {
        locale: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'ENGLISH')
      }
    })
  }
};

/**
 * Disambiguate from global Date object
 */
const DateIndexName = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.fieldNameHelpText', {
      defaultMessage: 'Field containing the date or timestamp.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.date_rounding,
    component: _shared_imports.SelectField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'dateRoundingField',
        options: [{
          value: 'y',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateRounding.year', {
            defaultMessage: 'Year'
          })
        }, {
          value: 'M',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateRounding.month', {
            defaultMessage: 'Month'
          })
        }, {
          value: 'w',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateRounding.week', {
            defaultMessage: 'Week'
          })
        }, {
          value: 'd',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateRounding.day', {
            defaultMessage: 'Day'
          })
        }, {
          value: 'h',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateRounding.hour', {
            defaultMessage: 'Hour'
          })
        }, {
          value: 'm',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateRounding.minute', {
            defaultMessage: 'Minute'
          })
        }, {
          value: 's',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateIndexNameForm.dateRounding.second', {
            defaultMessage: 'Second'
          })
        }]
      }
    },
    path: "fields.date_rounding"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "indexNamePrefixField",
    config: fieldsConfig.index_name_prefix,
    component: _shared_imports.Field,
    path: "fields.index_name_prefix"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "indexNameFormatField",
    config: fieldsConfig.index_name_format,
    component: _shared_imports.Field,
    path: "fields.index_name_format"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "dateFormatsField",
    config: fieldsConfig.date_formats,
    component: _shared_imports.ComboBoxField,
    path: "fields.date_formats"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "timezoneField",
    config: fieldsConfig.timezone,
    component: _shared_imports.Field,
    path: "fields.timezone"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "localeField",
    config: fieldsConfig.locale,
    component: _shared_imports.Field,
    path: "fields.locale"
  }));
};
exports.DateIndexName = DateIndexName;