"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUnifiedSearchContext = exports.useUnifiedSearch = exports.UnifiedSearchProvider = exports.UnifiedSearch = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_reload_request_time = require("../../../../hooks/use_reload_request_time");
var _use_kibana = require("../../../../hooks/use_kibana");
var _telemetry_time_range = require("../../../../../common/formatters/telemetry_time_range");
var _metrics_source = require("../../../../containers/metrics_source");
var _use_unified_search_url_state = require("./use_unified_search_url_state");
var _build = require("../../../../utils/filters/build");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildQuerySubmittedPayload = hostState => {
  const {
    panelFilters,
    filters,
    parsedDateRange,
    query: queryObj,
    limit
  } = hostState;
  return {
    control_filter_fields: (0, _build.retrieveFieldsFromFilter)(panelFilters),
    filter_fields: (0, _build.retrieveFieldsFromFilter)(filters),
    interval: (0, _telemetry_time_range.telemetryTimeRangeFormatter)(parsedDateRange.to - parsedDateRange.from),
    with_query: !!queryObj.query,
    limit
  };
};
const useUnifiedSearch = () => {
  const [error, setError] = (0, _react.useState)(null);
  const [searchCriteria, setSearch] = (0, _use_unified_search_url_state.useHostsUrlState)();
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const {
    updateReloadRequestTime
  } = (0, _use_reload_request_time.useReloadRequestTimeContext)();
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const kibanaQuerySettings = (0, _public.useKibanaQuerySettings)();
  const parsedDateRange = (0, _use_time_range.useTimeRange)({
    rangeFrom: searchCriteria.dateRange.from,
    rangeTo: searchCriteria.dateRange.to
  });
  const {
    data: {
      query: {
        filterManager: filterManagerService,
        queryString: queryStringService,
        timefilter: timeFilterService
      }
    },
    telemetry
  } = services;
  const validateQuery = (0, _react.useCallback)(query => {
    (0, _esQuery.fromKueryExpression)(query.query, kibanaQuerySettings);
  }, [kibanaQuerySettings]);
  const onFiltersChange = (0, _react.useCallback)(filters => {
    setSearch({
      type: 'SET_FILTERS',
      filters
    });
    updateReloadRequestTime();
  }, [setSearch, updateReloadRequestTime]);
  const onPanelFiltersChange = (0, _react.useCallback)(panelFilters => {
    setSearch({
      type: 'SET_PANEL_FILTERS',
      panelFilters
    });
    updateReloadRequestTime();
  }, [setSearch, updateReloadRequestTime]);
  const onLimitChange = (0, _react.useCallback)(limit => {
    setSearch({
      type: 'SET_LIMIT',
      limit
    });
    updateReloadRequestTime();
  }, [setSearch, updateReloadRequestTime]);
  const onDateRangeChange = (0, _react.useCallback)(dateRange => {
    setSearch({
      type: 'SET_DATE_RANGE',
      dateRange
    });
    updateReloadRequestTime();
  }, [setSearch, updateReloadRequestTime]);
  const onQueryChange = (0, _react.useCallback)(query => {
    try {
      setError(null);
      validateQuery(query);
      setSearch({
        type: 'SET_QUERY',
        query
      });
      updateReloadRequestTime();
    } catch (err) {
      setError(err);
    }
  }, [validateQuery, setSearch, updateReloadRequestTime]);
  const onSubmit = (0, _react.useCallback)(({
    dateRange
  }) => {
    onDateRangeChange(dateRange);
  }, [onDateRangeChange]);
  const getDateRangeAsTimestamp = (0, _react.useCallback)(() => {
    const from = new Date(parsedDateRange.from).getTime();
    const to = new Date(parsedDateRange.to).getTime();
    return {
      from,
      to
    };
  }, [parsedDateRange]);
  const buildQuery = (0, _react.useCallback)(() => {
    return (0, _esQuery.buildEsQuery)(metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, searchCriteria.query, [...searchCriteria.filters, ...searchCriteria.panelFilters], kibanaQuerySettings);
  }, [metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference, searchCriteria.query, searchCriteria.filters, searchCriteria.panelFilters, kibanaQuerySettings]);
  (0, _useEffectOnce.default)(() => {
    // Sync filtersService from the URL state
    if (!(0, _fastDeepEqual.default)(filterManagerService.getFilters(), searchCriteria.filters)) {
      filterManagerService.setFilters(searchCriteria.filters);
    }
    // Sync queryService from the URL state
    if (!(0, _fastDeepEqual.default)(queryStringService.getQuery(), searchCriteria.query)) {
      queryStringService.setQuery(searchCriteria.query);
    }
    try {
      // Validates the "query" object from the URL state
      if (searchCriteria.query) {
        validateQuery(searchCriteria.query);
      }
    } catch (err) {
      setError(err);
    }
  });
  (0, _react.useEffect)(() => {
    const subscription = new _rxjs.Subscription();
    subscription.add(filterManagerService.getUpdates$().pipe((0, _rxjs.map)(() => filterManagerService.getFilters()), (0, _rxjs.tap)(filters => onFiltersChange(filters))).subscribe());
    subscription.add(timeFilterService.timefilter.getTimeUpdate$().pipe((0, _rxjs.map)(() => timeFilterService.timefilter.getTime()), (0, _rxjs.tap)(dateRange => onDateRangeChange(dateRange))).subscribe());
    subscription.add(queryStringService.getUpdates$().pipe((0, _rxjs.map)(() => queryStringService.getQuery()), (0, _rxjs.tap)(query => onQueryChange(query))).subscribe());
    return () => {
      subscription.unsubscribe();
    };
  }, [filterManagerService, queryStringService, onQueryChange, onFiltersChange, timeFilterService.timefilter, onDateRangeChange]);

  // Track telemetry event on query/filter/date changes
  (0, _react.useEffect)(() => {
    const dateRangeInTimestamp = getDateRangeAsTimestamp();
    telemetry.reportHostsViewQuerySubmitted(buildQuerySubmittedPayload({
      ...searchCriteria,
      parsedDateRange: dateRangeInTimestamp
    }));
  }, [getDateRangeAsTimestamp, searchCriteria, telemetry]);
  return {
    error,
    buildQuery,
    onSubmit,
    parsedDateRange,
    getDateRangeAsTimestamp,
    searchCriteria,
    onDateRangeChange,
    onLimitChange,
    onPanelFiltersChange
  };
};
exports.useUnifiedSearch = useUnifiedSearch;
const UnifiedSearch = exports.UnifiedSearch = (0, _constate.default)(useUnifiedSearch);
const [UnifiedSearchProvider, useUnifiedSearchContext] = UnifiedSearch;
exports.useUnifiedSearchContext = useUnifiedSearchContext;
exports.UnifiedSearchProvider = UnifiedSearchProvider;