"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanUpJobsAndDatafeeds = void 0;
var _infra_ml = require("../../../common/infra_ml");
var _ml_cleanup = require("./api/ml_cleanup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cleanUpJobsAndDatafeeds = async (spaceId, sourceId, jobTypes, fetch) => {
  try {
    await (0, _ml_cleanup.callStopDatafeeds)({
      spaceId,
      sourceId,
      jobTypes
    }, fetch);
  } catch (err) {
    var _err$response;
    // Proceed only if datafeed has been deleted or didn't exist in the first place
    if ((err === null || err === void 0 ? void 0 : (_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.status) !== 404) {
      throw err;
    }
  }
  return await deleteJobs(spaceId, sourceId, jobTypes, fetch);
};
exports.cleanUpJobsAndDatafeeds = cleanUpJobsAndDatafeeds;
const deleteJobs = async (spaceId, sourceId, jobTypes, fetch) => {
  const deleteJobsResponse = await (0, _ml_cleanup.callDeleteJobs)({
    spaceId,
    sourceId,
    jobTypes
  }, fetch);
  await waitUntilJobsAreDeleted(spaceId, sourceId, jobTypes, fetch);
  return deleteJobsResponse;
};
const waitUntilJobsAreDeleted = async (spaceId, sourceId, jobTypes, fetch) => {
  const moduleJobIds = jobTypes.map(jobType => (0, _infra_ml.getJobId)(spaceId, sourceId, jobType));
  while (true) {
    const {
      jobs
    } = await (0, _ml_cleanup.callGetJobDeletionTasks)(fetch);
    const needToWait = jobs.flatMap(job => Object.keys(job)).some(jobId => moduleJobIds.includes(jobId));
    if (needToWait) {
      await timeout(1000);
    } else {
      return true;
    }
  }
};
const timeout = ms => new Promise(res => setTimeout(res, ms));