"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../services/documentation");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _edit_field = require("../fields/edit_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetaParameter = ({
  defaultToggleValue
}) => /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.metaParameterTitle', {
    defaultMessage: 'Set metadata'
  }),
  description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.metaParameterDescription', {
    defaultMessage: 'Arbitrary information about the field. Specify as JSON key-value pairs.'
  }),
  defaultToggleValue: defaultToggleValue,
  docLink: {
    text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.metaParameterDocLinkText', {
      defaultMessage: 'Metadata documentation'
    }),
    href: _documentation.documentationService.getMetaLink()
  },
  "data-test-subj": "metaParameter"
}, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: "meta",
  config: (0, _lib.getFieldConfig)('meta'),
  component: _shared_imports.JsonEditorField,
  componentProps: {
    codeEditorProps: {
      ['data-test-subj']: 'metaParameterEditor',
      height: '300px',
      'aria-label': _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.metaParameterAriaLabel', {
        defaultMessage: 'metadata field data editor'
      })
    }
  }
}));
exports.MetaParameter = MetaParameter;