"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TASK_TYPE = exports.TASK_TITLE = exports.TASK_TIMEOUT = void 0;
exports.formatError = formatError;
exports.getBulkOperationTaskResults = getBulkOperationTaskResults;
exports.scheduleBulkOperationTask = scheduleBulkOperationTask;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TASK_TYPE = exports.TASK_TYPE = 'fleet:packages-bulk-operations';
const TASK_TITLE = exports.TASK_TITLE = 'Fleet packages bulk operations';
const TASK_TIMEOUT = exports.TASK_TIMEOUT = '10m';
async function scheduleBulkOperationTask(taskManagerStart, taskParams) {
  const id = (0, _uuid.v4)();
  await taskManagerStart.ensureScheduled({
    id: `${TASK_TYPE}:${id}`,
    scope: ['fleet'],
    params: taskParams,
    taskType: TASK_TYPE,
    runAt: new Date(Date.now() + 3 * 1000),
    state: {}
  });
  return id;
}
async function getBulkOperationTaskResults(taskManagerStart, id) {
  var _state$results;
  const task = await taskManagerStart.get(`${TASK_TYPE}:${id}`);
  const state = task.state;
  const status = !(state !== null && state !== void 0 && state.isDone) ? 'pending' : state !== null && state !== void 0 && state.error || state !== null && state !== void 0 && (_state$results = state.results) !== null && _state$results !== void 0 && _state$results.some(r => !r.success) ? 'failed' : 'success';
  return {
    status,
    error: state.error,
    results: state.results
  };
}
function formatError(err) {
  return {
    message: err.message
  };
}