"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkMigrateAgents = bulkMigrateAgents;
exports.migrateSingleAgent = migrateSingleAgent;
var _errors = require("../../errors");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function migrateSingleAgent(esClient, agentId, agentPolicy, agent, options) {
  var _agent$components;
  //  If the agent belongs to a policy that is protected or has fleet-server as a component meaning its a fleet server agent, throw an error
  if (agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_protected || (_agent$components = agent.components) !== null && _agent$components !== void 0 && _agent$components.some(c => c.type === 'fleet-server')) {
    throw new _errors.FleetUnauthorizedError(`Agent is protected and cannot be migrated`);
  }
  const response = await (0, _actions.createAgentAction)(esClient, {
    agents: [agentId],
    created_at: new Date().toISOString(),
    type: 'MIGRATE',
    policyId: options.policyId,
    data: {
      enrollment_token: options.enrollment_token,
      target_uri: options.uri,
      settings: options.settings
    }
  });
  return {
    actionId: response.id
  };
}
async function bulkMigrateAgents(esClient, agents, agentPolicies, options) {
  // If any agent is protected or has fleet-server as a component, throw an error
  const protectedAgents = agentPolicies.filter(agentPolicy => agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_protected);
  const fleetServerAgents = agents.filter(agent => {
    var _agent$components2;
    return (_agent$components2 = agent.components) === null || _agent$components2 === void 0 ? void 0 : _agent$components2.some(c => c.type === 'fleet-server');
  });
  if (protectedAgents.length > 0 || fleetServerAgents.length > 0) {
    throw new _errors.FleetUnauthorizedError(`One or more agents are ${protectedAgents.length > 0 && fleetServerAgents.length > 0 ? 'protected and fleet-server' : protectedAgents.length > 0 ? 'protected' : 'fleet-server'} agents and cannot be migrated`);
  }
  const response = await (0, _actions.createAgentAction)(esClient, {
    agents: agents.map(agent => agent.id),
    created_at: new Date().toISOString(),
    type: 'MIGRATE',
    data: {
      enrollment_token: options.enrollment_token,
      target_uri: options.uri,
      settings: options.settings
    }
  });
  return {
    actionId: response.id
  };
}