"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendInstallPackage = exports.sendInstallKibanaAssetsForRq = exports.sendGetPackages = exports.sendGetPackageInfoByKeyForRq = exports.sendGetPackageInfoByKey = exports.sendGetOneBulkUpgradePackagesForRq = exports.sendGetOneBulkUninstallPackagesForRq = exports.sendGetFileByPath = exports.sendGetCategories = exports.sendGetBulkAssets = exports.sendDeletePackageDatastreamAssets = exports.sendBulkUpgradePackagesForRq = exports.sendBulkUninstallPackagesForRq = exports.sendBulkInstallPackages = void 0;
exports.sendRemovePackage = sendRemovePackage;
exports.sendRemovePackageForRq = sendRemovePackageForRq;
exports.sendUpdatePackage = exports.sendRequestReauthorizeTransforms = void 0;
exports.useGetAppendCustomIntegrationsQuery = useGetAppendCustomIntegrationsQuery;
exports.useGetCategoriesQuery = useGetCategoriesQuery;
exports.useGetFileByPathQuery = exports.useGetFileByPath = exports.useGetEpmDatastreams = void 0;
exports.useGetInputsTemplatesQuery = useGetInputsTemplatesQuery;
exports.useGetPackagesQuery = exports.useGetPackages = exports.useGetPackageVerificationKeyId = exports.useGetPackageStats = exports.useGetPackageInfoByKeyQuery = exports.useGetLimitedPackages = void 0;
exports.useGetReplacementCustomIntegrationsQuery = useGetReplacementCustomIntegrationsQuery;
exports.useUpdatePackageMutation = exports.useUpdateCustomIntegration = exports.useInstallKibanaAssetsMutation = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _custom_integrations = require("../../services/custom_integrations");
var _use_confirm_open_unverified = require("../../applications/integrations/hooks/use_confirm_open_unverified");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetAppendCustomIntegrationsQuery() {
  return (0, _reactQuery.useQuery)(['get-append-custom-integrations'], () => {
    const customIntegrations = (0, _custom_integrations.getCustomIntegrations)();
    return customIntegrations.getAppendCustomIntegrations();
  });
}
function useGetReplacementCustomIntegrationsQuery() {
  return (0, _reactQuery.useQuery)(['get-replacemenet-custom-integrations'], () => {
    const customIntegrations = (0, _custom_integrations.getCustomIntegrations)();
    return customIntegrations.getReplacementCustomIntegrations();
  });
}
function useGetCategoriesQuery(query = {}) {
  return (0, _reactQuery.useQuery)(['categories', query], () => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getCategoriesPath(),
    method: 'get',
    query,
    version: _constants.API_VERSIONS.public.v1
  }), {
    retry: (_, error) => !isRegistryConnectionError(error),
    refetchOnWindowFocus: false
  });
}
const sendGetCategories = (query = {}) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getCategoriesPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    query
  });
};
exports.sendGetCategories = sendGetCategories;
const useGetPackages = (query = {}) => {
  return (0, _use_request.useRequest)({
    path: _services.epmRouteService.getListPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    query
  });
};
exports.useGetPackages = useGetPackages;
const useGetPackagesQuery = (query, options) => {
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-packages', query],
    queryFn: () => (0, _use_request.sendRequestForRq)({
      path: _services.epmRouteService.getListPath(),
      method: 'get',
      version: _constants.API_VERSIONS.public.v1,
      query
    }),
    enabled: options === null || options === void 0 ? void 0 : options.enabled,
    retry: (_, error) => !isRegistryConnectionError(error),
    refetchOnWindowFocus: false
  });
};
exports.useGetPackagesQuery = useGetPackagesQuery;
const sendGetPackages = (query = {}) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getListPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    query
  });
};
exports.sendGetPackages = sendGetPackages;
const useGetLimitedPackages = () => {
  return (0, _use_request.useRequest)({
    path: _services.epmRouteService.getListLimitedPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.useGetLimitedPackages = useGetLimitedPackages;
const useUpdateCustomIntegration = async (id, fields) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getUpdateCustomIntegrationsPath(id),
    method: 'put',
    version: _constants.API_VERSIONS.public.v1,
    body: {
      readMeData: fields.readMeData,
      categories: fields.categories
    }
  });
};
exports.useUpdateCustomIntegration = useUpdateCustomIntegration;
const useGetPackageInfoByKeyQuery = (pkgName, pkgVersion, options,
// Additional options for the useQuery hook
queryOptions = {
  enabled: true
}) => {
  const confirmOpenUnverified = (0, _use_confirm_open_unverified.useConfirmOpenUnverified)();
  const [ignoreUnverifiedQueryParam, setIgnoreUnverifiedQueryParam] = (0, _react.useState)(options === null || options === void 0 ? void 0 : options.ignoreUnverified);
  const response = (0, _reactQuery.useQuery)([pkgName, pkgVersion, options], () => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getInfoPath(pkgName, pkgVersion),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    query: {
      ...options,
      ...(ignoreUnverifiedQueryParam && {
        ignoreUnverified: ignoreUnverifiedQueryParam
      })
    }
  }), {
    suspense: queryOptions.suspense,
    enabled: queryOptions.enabled,
    refetchOnMount: queryOptions.refetchOnMount,
    retry: (_, error) => !isRegistryConnectionError(error),
    refetchOnWindowFocus: false
  });
  const confirm = async () => {
    const forceInstall = await confirmOpenUnverified(pkgName);
    if (forceInstall) {
      setIgnoreUnverifiedQueryParam(true);
    }
  };
  if (response !== null && response !== void 0 && response.error && (0, _services.isVerificationError)(response === null || response === void 0 ? void 0 : response.error)) {
    confirm();
  }
  return response;
};
exports.useGetPackageInfoByKeyQuery = useGetPackageInfoByKeyQuery;
const useGetPackageStats = pkgName => {
  return (0, _use_request.useRequest)({
    path: _services.epmRouteService.getStatsPath(pkgName),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.useGetPackageStats = useGetPackageStats;
const useGetPackageVerificationKeyId = () => {
  const {
    data,
    ...rest
  } = (0, _reactQuery.useQuery)(['verification_key_id'], () => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getVerificationKeyIdPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  }));
  return {
    packageVerificationKeyId: (data === null || data === void 0 ? void 0 : data.id) || undefined,
    ...rest
  };
};

/**
 * @deprecated use sendGetPackageInfoByKeyForRq instead
 */
exports.useGetPackageVerificationKeyId = useGetPackageVerificationKeyId;
const sendGetPackageInfoByKey = (pkgName, pkgVersion, options) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getInfoPath(pkgName, pkgVersion),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    query: options
  });
};
exports.sendGetPackageInfoByKey = sendGetPackageInfoByKey;
const sendGetPackageInfoByKeyForRq = (pkgName, pkgVersion, options) => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getInfoPath(pkgName, pkgVersion),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1,
    query: options
  });
};
exports.sendGetPackageInfoByKeyForRq = sendGetPackageInfoByKeyForRq;
const useGetFileByPath = filePath => {
  return (0, _use_request.useRequest)({
    path: _services.epmRouteService.getFilePath(filePath),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.useGetFileByPath = useGetFileByPath;
const useGetFileByPathQuery = filePath => {
  return (0, _reactQuery.useQuery)(['get-file', filePath], () => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getFilePath(filePath),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  }));
};
exports.useGetFileByPathQuery = useGetFileByPathQuery;
const useGetEpmDatastreams = () => {
  return (0, _reactQuery.useQuery)(['get-epm-datastreams'], () => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getDatastreamsPath(),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  }));
};
exports.useGetEpmDatastreams = useGetEpmDatastreams;
const sendGetFileByPath = filePath => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getFilePath(filePath),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendGetFileByPath = sendGetFileByPath;
const sendInstallPackage = (pkgName, pkgVersion, force = false) => {
  const body = force ? {
    force
  } : undefined;
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getInstallPath(pkgName, pkgVersion),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body
  });
};
exports.sendInstallPackage = sendInstallPackage;
const sendBulkInstallPackages = packages => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getBulkInstallPath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: {
      packages
    }
  });
};
exports.sendBulkInstallPackages = sendBulkInstallPackages;
const sendBulkUpgradePackagesForRq = params => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getBulkUpgradePath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: params
  });
};
exports.sendBulkUpgradePackagesForRq = sendBulkUpgradePackagesForRq;
const sendBulkUninstallPackagesForRq = params => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getBulkUninstallPath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: params
  });
};
exports.sendBulkUninstallPackagesForRq = sendBulkUninstallPackagesForRq;
const sendGetOneBulkUpgradePackagesForRq = taskId => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getOneBulkUpgradePath(taskId),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};
exports.sendGetOneBulkUpgradePackagesForRq = sendGetOneBulkUpgradePackagesForRq;
const sendGetOneBulkUninstallPackagesForRq = taskId => {
  return (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getOneBulkUninstallPath(taskId),
    method: 'get',
    version: _constants.API_VERSIONS.public.v1
  });
};

/**
 * @deprecated use sendRemovePackageForRq instead
 */
exports.sendGetOneBulkUninstallPackagesForRq = sendGetOneBulkUninstallPackagesForRq;
function sendRemovePackage({
  pkgName,
  pkgVersion
}, query) {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getRemovePath(pkgName, pkgVersion),
    method: 'delete',
    version: _constants.API_VERSIONS.public.v1,
    query
  });
}
function sendRemovePackageForRq({
  pkgName,
  pkgVersion
}, query) {
  return (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getRemovePath(pkgName, pkgVersion),
    method: 'delete',
    version: _constants.API_VERSIONS.public.v1,
    query
  });
}
const sendRequestReauthorizeTransforms = (pkgName, pkgVersion, transforms) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getReauthorizeTransformsPath(pkgName, pkgVersion),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body: {
      transforms
    }
  });
};
exports.sendRequestReauthorizeTransforms = sendRequestReauthorizeTransforms;
const useUpdatePackageMutation = () => {
  return (0, _reactQuery.useMutation)(({
    pkgName,
    pkgVersion,
    body
  }) => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getUpdatePath(pkgName, pkgVersion),
    method: 'put',
    version: _constants.API_VERSIONS.public.v1,
    body
  }));
};
exports.useUpdatePackageMutation = useUpdatePackageMutation;
const useInstallKibanaAssetsMutation = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)({
    mutationFn: ({
      pkgName,
      pkgVersion
    }) => sendInstallKibanaAssetsForRq({
      pkgName,
      pkgVersion
    }),
    onSuccess: (data, {
      pkgName,
      pkgVersion
    }) => {
      return queryClient.invalidateQueries([pkgName, pkgVersion]);
    }
  });
};
exports.useInstallKibanaAssetsMutation = useInstallKibanaAssetsMutation;
const sendInstallKibanaAssetsForRq = ({
  pkgName,
  pkgVersion,
  spaceIds
}) => (0, _use_request.sendRequestForRq)({
  path: _services.epmRouteService.getInstallKibanaAssetsPath(pkgName, pkgVersion),
  method: 'post',
  version: _constants.API_VERSIONS.public.v1,
  body: spaceIds ? {
    space_ids: spaceIds
  } : undefined
});
exports.sendInstallKibanaAssetsForRq = sendInstallKibanaAssetsForRq;
const sendUpdatePackage = (pkgName, pkgVersion, body) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getUpdatePath(pkgName, pkgVersion),
    method: 'put',
    version: _constants.API_VERSIONS.public.v1,
    body
  });
};
exports.sendUpdatePackage = sendUpdatePackage;
const sendGetBulkAssets = body => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getBulkAssetsPath(),
    method: 'post',
    version: _constants.API_VERSIONS.public.v1,
    body
  });
};
exports.sendGetBulkAssets = sendGetBulkAssets;
const sendDeletePackageDatastreamAssets = ({
  pkgName,
  pkgVersion
}, query) => {
  return (0, _use_request.sendRequest)({
    path: _services.epmRouteService.getDeletePackageDatastreamAssets(pkgName, pkgVersion),
    method: 'delete',
    version: _constants.API_VERSIONS.public.v1,
    query
  });
};
exports.sendDeletePackageDatastreamAssets = sendDeletePackageDatastreamAssets;
function useGetInputsTemplatesQuery({
  pkgName,
  pkgVersion
}, query) {
  return (0, _reactQuery.useQuery)(['inputsTemplates', pkgName, pkgVersion, query], () => (0, _use_request.sendRequestForRq)({
    path: _services.epmRouteService.getInputsTemplatesPath(pkgName, pkgVersion),
    method: 'get',
    query,
    version: _constants.API_VERSIONS.public.v1
  }));
}
function isRegistryConnectionError(error) {
  return error.statusCode === 502;
}