"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootPrivilegesCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RootPrivilegesCallout = ({
  rootIntegrations = []
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return rootIntegrations.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollmentCallout.rootPrivilegesTitle', {
      defaultMessage: 'Root privileges required'
    }),
    "data-test-subj": "rootPrivilegesCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollmentCallout.rootPrivilegesMessage",
    defaultMessage: "This agent policy contains the following integrations that require Elastic Agents to have root privileges. To ensure that all data required by the integrations can be collected, enroll the agents using an account with root privileges. For more information, see the {guideLink}",
    values: {
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.unprivilegedMode,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentEnrollmentCallout.rootPrivilegesMessage.guideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement("ul", null, rootIntegrations.map(item => /*#__PURE__*/_react.default.createElement("li", {
    key: item.name
  }, item.title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null;
};
exports.RootPrivilegesCallout = RootPrivilegesCallout;