"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddUrlFilters = useAddUrlFilters;
exports.useUrlFilters = useUrlFilters;
exports.useViewPolicies = useViewPolicies;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _hooks = require("../../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAddUrlFilters() {
  const urlFilters = useUrlFilters();
  const {
    toUrlParams,
    urlParams
  } = (0, _hooks.useUrlParams)();
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _react.useCallback)(filters => {
    var _newFilters$customInt;
    const newFilters = {
      ...urlFilters,
      ...filters
    };
    history.push({
      search: toUrlParams({
        ...(0, _lodash.omit)(urlParams, 'installationStatus', 'q'),
        // Reset current page when changing filters
        currentPage: '1',
        ...(Object.hasOwn(newFilters, 'installationStatus') ? {
          installationStatus: newFilters.installationStatus
        } : {}),
        ...(Object.hasOwn(newFilters, 'customIntegrations') ? {
          customIntegrations: (_newFilters$customInt = newFilters.customIntegrations) === null || _newFilters$customInt === void 0 ? void 0 : _newFilters$customInt.toString()
        } : {}),
        ...(Object.hasOwn(newFilters, 'q') ? {
          q: newFilters.q
        } : {})
      }, {
        skipEmptyString: true
      })
    });
  }, [urlFilters, urlParams, toUrlParams, history]);
}
function useViewPolicies() {
  const {
    toUrlParams,
    urlParams
  } = (0, _hooks.useUrlParams)();
  const history = (0, _reactRouterDom.useHistory)();
  const addViewPolicies = (0, _react.useCallback)(packageName => {
    history.push({
      search: toUrlParams({
        ...(0, _lodash.omit)(urlParams, 'viewPolicies'),
        ...(packageName ? {
          viewPolicies: packageName
        } : {})
      }, {
        skipEmptyString: true
      })
    });
  }, [urlParams, toUrlParams, history]);
  const selectedPackageViewPolicies = (0, _react.useMemo)(() => {
    if (typeof urlParams.viewPolicies === 'string') {
      return urlParams.viewPolicies;
    }
  }, [urlParams]);
  return {
    addViewPolicies,
    selectedPackageViewPolicies
  };
}
function useUrlFilters() {
  const {
    urlParams
  } = (0, _hooks.useUrlParams)();
  return (0, _react.useMemo)(() => {
    let installationStatus;
    if (urlParams.installationStatus) {
      if (typeof urlParams.installationStatus === 'string') {
        installationStatus = [urlParams.installationStatus];
      } else {
        installationStatus = urlParams.installationStatus;
      }
    }
    let q;
    if (typeof urlParams.q === 'string') {
      q = urlParams.q;
    }
    let customIntegrations;
    if (typeof urlParams.customIntegrations === 'string' && urlParams.customIntegrations === 'true') {
      customIntegrations = true;
    }
    return {
      installationStatus,
      customIntegrations,
      q
    };
  }, [urlParams]);
}