"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectedRoute = void 0;
exports.renderApp = renderApp;
exports.teardownIntegrations = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _hooks = require("../../hooks");
var _app = require("./app");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProtectedRoute = ({
  isAllowed = false,
  restrictedPath = '/',
  ...routeProps
}) => {
  return isAllowed ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, routeProps) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: restrictedPath
    }
  });
};
exports.ProtectedRoute = ProtectedRoute;
const IntegrationsApp = ({
  basepath,
  startServices,
  config,
  history,
  kibanaVersion,
  extensions,
  setHeaderActionMenu
}) => {
  return /*#__PURE__*/_react.default.createElement(_app.IntegrationsAppContext, {
    basepath: basepath,
    startServices: startServices,
    config: config,
    history: history,
    kibanaVersion: kibanaVersion,
    extensions: extensions,
    setHeaderActionMenu: setHeaderActionMenu
  }, /*#__PURE__*/_react.default.createElement(_app.AppRoutes, null));
};
function renderApp(startServices, {
  element,
  appBasePath,
  history,
  setHeaderActionMenu
}, config, kibanaVersion, extensions, UsageTracker) {
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(UsageTracker, null, /*#__PURE__*/_react.default.createElement(IntegrationsApp, {
    basepath: appBasePath,
    startServices: startServices,
    config: config,
    history: history,
    kibanaVersion: kibanaVersion,
    extensions: extensions,
    setHeaderActionMenu: setHeaderActionMenu
  })), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
}
const teardownIntegrations = coreStart => {
  coreStart.chrome.docTitle.reset();
  coreStart.chrome.setBreadcrumbs([]);
  _hooks.licenseService.stop();
};
exports.teardownIntegrations = teardownIntegrations;