"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformKnowledgeBaseEntryBulkActionResponse = exports.PerformKnowledgeBaseEntryBulkActionRequestBody = exports.NormalizedKnowledgeBaseEntryError = exports.KnowledgeBaseEntryDetailsInError = exports.KnowledgeBaseEntryBulkCrudActionSummary = exports.KnowledgeBaseEntryBulkCrudActionResults = exports.KnowledgeBaseEntryBulkCrudActionResponse = exports.KnowledgeBaseEntryBulkActionSkipResult = exports.KnowledgeBaseEntryBulkActionSkipReason = exports.KnowledgeBaseEntryBulkActionBase = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("./common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Knowledge Base Actions API endpoint
 *   version: 2023-10-31
 */

/**
 * Reason why a Knowledge Base Entry was skipped during the bulk action.
 */

const KnowledgeBaseEntryBulkActionSkipReason = exports.KnowledgeBaseEntryBulkActionSkipReason = _zod.z.literal('KNOWLEDGE_BASE_ENTRY_NOT_MODIFIED');
const KnowledgeBaseEntryBulkActionSkipResult = exports.KnowledgeBaseEntryBulkActionSkipResult = _zod.z.object({
  /**
   * ID of the skipped Knowledge Base Entry.
   */
  id: _zod.z.string(),
  /**
   * Name of the skipped Knowledge Base Entry.
   */
  name: _zod.z.string().optional(),
  skip_reason: KnowledgeBaseEntryBulkActionSkipReason
});
const KnowledgeBaseEntryDetailsInError = exports.KnowledgeBaseEntryDetailsInError = _zod.z.object({
  /**
   * ID of the Knowledge Base Entry that encountered an error.
   */
  id: _zod.z.string(),
  /**
   * Name of the Knowledge Base Entry that encountered an error.
   */
  name: _zod.z.string().optional()
});
const NormalizedKnowledgeBaseEntryError = exports.NormalizedKnowledgeBaseEntryError = _zod.z.object({
  /**
   * Error message describing the issue.
   */
  message: _zod.z.string(),
  /**
   * HTTP status code associated with the error.
   */
  statusCode: _zod.z.number().int(),
  /**
   * Specific error code for the issue.
   */
  err_code: _zod.z.string().optional(),
  /**
   * List of Knowledge Base Entries that encountered the error.
   */
  knowledgeBaseEntries: _zod.z.array(KnowledgeBaseEntryDetailsInError)
});
const KnowledgeBaseEntryBulkCrudActionResults = exports.KnowledgeBaseEntryBulkCrudActionResults = _zod.z.object({
  /**
   * List of Knowledge Base Entries that were successfully updated.
   */
  updated: _zod.z.array(_common_attributes.KnowledgeBaseEntryResponse),
  /**
   * List of Knowledge Base Entries that were successfully created.
   */
  created: _zod.z.array(_common_attributes.KnowledgeBaseEntryResponse),
  /**
   * List of IDs of Knowledge Base Entries that were successfully deleted.
   */
  deleted: _zod.z.array(_zod.z.string()),
  /**
   * List of Knowledge Base Entries that were skipped during the bulk action.
   */
  skipped: _zod.z.array(KnowledgeBaseEntryBulkActionSkipResult)
});
const KnowledgeBaseEntryBulkCrudActionSummary = exports.KnowledgeBaseEntryBulkCrudActionSummary = _zod.z.object({
  /**
   * Number of Knowledge Base Entries that failed during the bulk action.
   */
  failed: _zod.z.number().int(),
  /**
   * Number of Knowledge Base Entries that were skipped during the bulk action.
   */
  skipped: _zod.z.number().int(),
  /**
   * Number of Knowledge Base Entries that were successfully processed during the bulk action.
   */
  succeeded: _zod.z.number().int(),
  /**
   * Total number of Knowledge Base Entries involved in the bulk action.
   */
  total: _zod.z.number().int()
});
const KnowledgeBaseEntryBulkCrudActionResponse = exports.KnowledgeBaseEntryBulkCrudActionResponse = _zod.z.object({
  /**
   * Indicates whether the bulk action was successful.
   */
  success: _zod.z.boolean().optional(),
  /**
   * HTTP status code of the response.
   */
  statusCode: _zod.z.number().int().optional(),
  /**
   * Message describing the result of the bulk action.
   */
  message: _zod.z.string().optional(),
  /**
   * Total number of Knowledge Base Entries processed.
   */
  knowledgeBaseEntriesCount: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: KnowledgeBaseEntryBulkCrudActionResults,
    summary: KnowledgeBaseEntryBulkCrudActionSummary,
    /**
     * List of errors encountered during the bulk action.
     */
    errors: _zod.z.array(NormalizedKnowledgeBaseEntryError).optional()
  })
});
const KnowledgeBaseEntryBulkActionBase = exports.KnowledgeBaseEntryBulkActionBase = _zod.z.object({
  /**
   * Query to filter Knowledge Base Entries.
   */
  query: _zod.z.string().optional(),
  /**
   * Array of Knowledge Base Entry IDs.
   */
  ids: _zod.z.array(_zod.z.string()).min(1).optional()
});
const PerformKnowledgeBaseEntryBulkActionRequestBody = exports.PerformKnowledgeBaseEntryBulkActionRequestBody = _zod.z.object({
  delete: KnowledgeBaseEntryBulkActionBase.optional(),
  /**
   * List of Knowledge Base Entries to create.
   */
  create: _zod.z.array(_common_attributes.KnowledgeBaseEntryCreateProps).optional(),
  /**
   * List of Knowledge Base Entries to update.
   */
  update: _zod.z.array(_common_attributes.KnowledgeBaseEntryUpdateProps).optional()
});
const PerformKnowledgeBaseEntryBulkActionResponse = exports.PerformKnowledgeBaseEntryBulkActionResponse = KnowledgeBaseEntryBulkCrudActionResponse;