"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = EmptyStateWrapper;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_dataset_quality_state = require("../../../hooks/use_dataset_quality_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function EmptyStateWrapper({
  children
}) {
  const {
    canUserMonitorAnyDataset,
    statsLoading
  } = (0, _use_dataset_quality_state.useDatasetQualityState)();
  if (!statsLoading && !canUserMonitorAnyDataset) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      color: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.datasetQuality.emptyState.noPrivileges.title', {
        defaultMessage: `Datasets couldn't be loaded`
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        "data-test-subj": "datasetQualityNoPrivilegesEmptyState"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.datasetQuality.emptyState.noPrivileges.message",
        defaultMessage: "You don't have the required privileges to view data sets data. Make sure you have sufficient privileges to view data sets."
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
}
module.exports = exports.default;