"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _classnames = _interopRequireDefault(require("classnames"));
var _coreApplicationCommon = require("@kbn/core-application-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const AppWrapper = ({
  chromeVisible$,
  children
}) => {
  const visible = (0, _useObservable.default)(chromeVisible$);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)(_coreApplicationCommon.APP_WRAPPER_CLASS, {
      'kbnAppWrapper--hiddenChrome': !visible
    }),
    "data-test-subj": `kbnAppWrapper ${visible ? 'visible' : 'hidden'}Chrome`
  }, children);
};
exports.AppWrapper = AppWrapper;