"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _main = require("./containers/main");
var _services = require("../services");
var _tracker = require("../services/tracker");
var _kb = require("../lib/kb");
var localStorageObjectClient = _interopRequireWildcard(require("../lib/local_storage_object_client"));
var _containers = require("./containers");
var _contexts = require("./contexts");
var _lib = require("./lib");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const RedirectToShell = () => {
  const location = (0, _reactRouterDom.useLocation)();
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: `/console/shell${location.search}`
  });
};
async function renderApp({
  notifications,
  docLinkVersion,
  usageCollection,
  application,
  dataViews,
  data,
  licensing,
  element,
  history,
  http,
  docLinks,
  autocompleteInfo,
  isDevMode,
  ...startServices
}) {
  const trackUiMetric = (0, _tracker.createUsageTracker)(usageCollection);
  trackUiMetric.load('opened_app');
  await (0, _kb.loadActiveApi)(http);
  const storage = (0, _services.createStorage)({
    engine: window.localStorage,
    prefix: 'sense:'
  });
  (0, _services.setStorage)(storage);
  const storageHistory = (0, _services.createHistory)({
    storage
  });
  const settings = (0, _services.createSettings)({
    storage
  });
  const objectStorageClient = localStorageObjectClient.create(storage);
  const api = (0, _lib.createApi)({
    http
  });
  const esHostService = (0, _lib.createEsHostService)({
    api
  });
  autocompleteInfo.mapping.setup(http, settings);
  (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, startServices, /*#__PURE__*/_react.default.createElement(_contexts.ServicesContextProvider, {
    value: {
      ...startServices,
      docLinkVersion,
      docLinks,
      services: {
        esHostService,
        storage,
        history: storageHistory,
        routeHistory: history,
        settings,
        notifications,
        trackUiMetric,
        objectStorageClient,
        http,
        autocompleteInfo,
        application,
        dataViews,
        data,
        licensing
      },
      config: {
        isDevMode
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_contexts.RequestContextProvider, null, /*#__PURE__*/_react.default.createElement(_contexts.EditorContextProvider, {
    settings: settings.toJSON()
  }, history ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, [_main.SHELL_TAB_ID, _main.HISTORY_TAB_ID, _main.CONFIG_TAB_ID].map(tab => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    key: tab,
    path: `/console/${tab}`
  }, /*#__PURE__*/_react.default.createElement(_containers.Main, {
    currentTabProp: tab
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    key: "redirect",
    path: "/console"
  }, /*#__PURE__*/_react.default.createElement(RedirectToShell, null)))) : /*#__PURE__*/_react.default.createElement(_containers.Main, null))))), element);
  return () => (0, _reactDom.unmountComponentAtNode)(element);
}