"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompactFormattedNumber = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CompactFormattedNumber = ({
  number,
  abbreviateAbove = 999999
}) => {
  if (!number && number !== 0) {
    return /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.csp.compactFormattedNumber.naTitle', {
      defaultMessage: 'N/A'
    }));
  }
  if (number <= abbreviateAbove) {
    return /*#__PURE__*/_react.default.createElement("span", null, number.toLocaleString());
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: number.toLocaleString()
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0
  }, number.toLocaleString(undefined, {
    notation: 'compact',
    maximumFractionDigits: 1
  })));
};
exports.CompactFormattedNumber = CompactFormattedNumber;