"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHasWorkpads = getHasWorkpads;
var _constants = require("../../common/lib/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHasWorkpads(http) {
  try {
    var _hasWorkpads;
    const response = await http.get(`${_constants.API_ROUTE_WORKPAD}/hasWorkpads`, {
      version: '1'
    });
    return (_hasWorkpads = response === null || response === void 0 ? void 0 : response.hasWorkpads) !== null && _hasWorkpads !== void 0 ? _hasWorkpads : false;
  } catch (error) {
    return false;
  }
}