"use strict";
/*
 * ELASTICSEARCH CONFIDENTIAL
 * __________________
 *
 *  Copyright Elasticsearch B.V. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Elasticsearch B.V. and its suppliers, if any.
 * The intellectual and technical concepts contained herein
 * are proprietary to Elasticsearch B.V. and its suppliers and
 * may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright
 * law.  Dissemination of this information or reproduction of
 * this material is strictly forbidden unless prior written
 * permission is obtained from Elasticsearch B.V.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var path_1 = require("path");
var config_service_1 = require("./config/config_service");
var server_1 = require("./server");
var logger_1 = require("./logger");
var licensecheck_1 = require("./licensecheck");
var read_config_1 = require("./utils/read_config");
var tileservice_1 = require("./tileservice");
var server;
var startServer = function () { return __awaiter(void 0, void 0, void 0, function () {
    var logger, configFile, rawConfig, config, pkg, version, tileDbPath, tileService, clusterOptions, requiredLicense, licenseChecker, params;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                logger = (0, logger_1.getLogger)();
                configFile = process.env.EMS_PATH_CONF || config_service_1.Constants.DEFAULT_EMS_PATH_CONF;
                rawConfig = (0, read_config_1.getConfigFromFiles)([configFile]);
                config = new config_service_1.ConfigurationService(rawConfig, logger);
                pkg = (0, path_1.resolve)(config.appPaths.ems, 'server', 'package.json');
                version = process.env.ELASTIC_VERSION || (0, read_config_1.getPackageVersion)(pkg);
                if (!server) return [3 /*break*/, 2];
                return [4 /*yield*/, server.stop({ timeout: 50 })];
            case 1:
                _a.sent();
                _a.label = 2;
            case 2:
                tileDbPath = config.appPaths.planet;
                tileService = new tileservice_1.TileService(tileDbPath, logger);
                tileService.init();
                clusterOptions = config.elasticsearchConfig;
                requiredLicense = config_service_1.Constants.ELASTIC_REQUIRED_LICENSE;
                licenseChecker = new licensecheck_1.LicenseCheck(clusterOptions, requiredLicense, config_service_1.Constants.ELASTIC_CHECK_INTERVAL, logger);
                licenseChecker.init();
                params = {
                    config: config,
                    logger: logger,
                    tileService: tileService,
                    licenseChecker: licenseChecker,
                    version: version,
                };
                return [4 /*yield*/, (0, server_1.init)(params)];
            case 3:
                // Get the appropriate server object
                server = _a.sent();
                server.start();
                return [2 /*return*/];
        }
    });
}); };
(function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        startServer().catch(function (error) {
            console.error(error.message || error);
            process.exit(1);
        });
        return [2 /*return*/];
    });
}); })();
//# sourceMappingURL=index.js.map