/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class BulkByScrollResponse
extends ActionResponse
implements ToXContentFragment {
    private final TimeValue took;
    private final BulkByScrollTask.Status status;
    private final List<BulkItemResponse.Failure> bulkFailures;
    private final List<ScrollableHitSource.SearchFailure> searchFailures;
    private boolean timedOut;
    static final String TOOK_FIELD = "took";
    static final String TIMED_OUT_FIELD = "timed_out";
    static final String FAILURES_FIELD = "failures";

    public BulkByScrollResponse(StreamInput in) throws IOException {
        this.took = in.readTimeValue();
        this.status = new BulkByScrollTask.Status(in);
        this.bulkFailures = in.readCollectionAsList(BulkItemResponse.Failure::new);
        this.searchFailures = in.readCollectionAsList(ScrollableHitSource.SearchFailure::new);
        this.timedOut = in.readBoolean();
    }

    public BulkByScrollResponse(TimeValue took, BulkByScrollTask.Status status, List<BulkItemResponse.Failure> bulkFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        this.took = took;
        this.status = Objects.requireNonNull(status, "Null status not supported");
        this.bulkFailures = bulkFailures;
        this.searchFailures = searchFailures;
        this.timedOut = timedOut;
    }

    public BulkByScrollResponse(Iterable<BulkByScrollResponse> toMerge, @Nullable String reasonCancelled) {
        long mergedTook = 0L;
        ArrayList<BulkByScrollTask.StatusOrException> statuses = new ArrayList<BulkByScrollTask.StatusOrException>();
        this.bulkFailures = new ArrayList<BulkItemResponse.Failure>();
        this.searchFailures = new ArrayList<ScrollableHitSource.SearchFailure>();
        for (BulkByScrollResponse response : toMerge) {
            mergedTook = Math.max(mergedTook, response.getTook().nanos());
            statuses.add(new BulkByScrollTask.StatusOrException(response.status));
            this.bulkFailures.addAll(response.getBulkFailures());
            this.searchFailures.addAll(response.getSearchFailures());
            this.timedOut |= response.isTimedOut();
        }
        this.took = TimeValue.timeValueNanos((long)mergedTook);
        this.status = new BulkByScrollTask.Status(statuses, reasonCancelled);
    }

    public TimeValue getTook() {
        return this.took;
    }

    public BulkByScrollTask.Status getStatus() {
        return this.status;
    }

    public long getCreated() {
        return this.status.getCreated();
    }

    public long getTotal() {
        return this.status.getTotal();
    }

    public long getDeleted() {
        return this.status.getDeleted();
    }

    public long getUpdated() {
        return this.status.getUpdated();
    }

    public int getBatches() {
        return this.status.getBatches();
    }

    public long getVersionConflicts() {
        return this.status.getVersionConflicts();
    }

    public long getNoops() {
        return this.status.getNoops();
    }

    public String getReasonCancelled() {
        return this.status.getReasonCancelled();
    }

    public long getBulkRetries() {
        return this.status.getBulkRetries();
    }

    public long getSearchRetries() {
        return this.status.getSearchRetries();
    }

    public List<BulkItemResponse.Failure> getBulkFailures() {
        return this.bulkFailures;
    }

    public List<ScrollableHitSource.SearchFailure> getSearchFailures() {
        return this.searchFailures;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeTimeValue(this.took);
        this.status.writeTo(out);
        out.writeCollection(this.bulkFailures);
        out.writeCollection(this.searchFailures);
        out.writeBoolean(this.timedOut);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(TOOK_FIELD, this.took.millis());
        builder.field(TIMED_OUT_FIELD, this.timedOut);
        this.status.innerXContent(builder, params);
        builder.startArray(FAILURES_FIELD);
        for (BulkItemResponse.Failure failure : this.bulkFailures) {
            builder.startObject();
            failure.toXContent(builder, params);
            builder.endObject();
        }
        for (ScrollableHitSource.SearchFailure searchFailure : this.searchFailures) {
            searchFailure.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("[");
        builder.append("took=").append(this.took).append(',');
        builder.append("timed_out=").append(this.timedOut).append(',');
        this.status.innerToString(builder);
        builder.append(",bulk_failures=").append(this.getBulkFailures().subList(0, Math.min(3, this.getBulkFailures().size())));
        builder.append(",search_failures=").append(this.getSearchFailures().subList(0, Math.min(3, this.getSearchFailures().size())));
        return builder.append(']').toString();
    }
}

