/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.rule.Rule;

public final class PruneColumns
extends Rule<LogicalPlan, LogicalPlan> {
    @Override
    public LogicalPlan apply(LogicalPlan plan) {
        AttributeSet.Builder used = plan.outputSet().asBuilder();
        Holder forkPresent = new Holder((Object)false);
        LogicalPlan pl = (LogicalPlan)plan.transformDown(p -> {
            boolean recheck;
            if (p instanceof Limit) {
                return p;
            }
            if (p instanceof Fork) {
                forkPresent.set((Object)true);
            }
            if (((Boolean)forkPresent.get()).booleanValue()) {
                return p;
            }
            do {
                EsRelation esr;
                List<? extends NamedExpression> remaining;
                recheck = false;
                if (p instanceof Aggregate) {
                    Aggregate aggregate = (Aggregate)p;
                    remaining = PruneColumns.removeUnused(aggregate.aggregates(), used);
                    if (remaining == null) continue;
                    if (remaining.isEmpty()) {
                        if (aggregate.groupings().isEmpty()) {
                            p = new LocalRelation(aggregate.source(), List.of(Expressions.attribute((Expression)((Expression)aggregate.aggregates().getFirst()))), LocalSupplier.of(new Block[]{BlockUtils.constantBlock((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, null, (int)1)}));
                            continue;
                        }
                        Attribute attribute = Expressions.attribute((Expression)aggregate.groupings().getFirst());
                        NamedExpression firstAggregate = aggregate.aggregates().getFirst();
                        remaining = List.of(new Alias(firstAggregate.source(), firstAggregate.name(), (Expression)attribute, firstAggregate.id()));
                        p = aggregate.with(aggregate.groupings(), remaining);
                        continue;
                    }
                    p = aggregate.with(aggregate.groupings(), remaining);
                    continue;
                }
                if (p instanceof Eval) {
                    Eval eval = (Eval)p;
                    remaining = PruneColumns.removeUnused(eval.fields(), used);
                    if (remaining == null) continue;
                    if (remaining.isEmpty()) {
                        p = eval.child();
                        recheck = true;
                        continue;
                    }
                    p = new Eval(eval.source(), eval.child(), remaining);
                    continue;
                }
                if (!(p instanceof EsRelation) || (esr = (EsRelation)((Object)p)).indexMode() != IndexMode.LOOKUP || (remaining = PruneColumns.removeUnused(esr.output(), used)) == null) continue;
                p = new EsRelation(esr.source(), esr.indexPattern(), esr.indexMode(), esr.indexNameWithModes(), remaining);
            } while (recheck);
            used.addAll(p.references());
            return p;
        });
        return pl;
    }

    private static <N extends NamedExpression> List<N> removeUnused(List<N> named, AttributeSet.Builder used) {
        ArrayList<N> clone = new ArrayList<N>(named);
        ListIterator<N> it = clone.listIterator(clone.size());
        while (it.hasPrevious()) {
            NamedExpression prev = (NamedExpression)it.previous();
            if (!used.contains((Object)prev.toAttribute())) {
                it.remove();
                continue;
            }
            used.addAll(prev.references());
        }
        return clone.size() != named.size() ? clone : null;
    }
}

